/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class WootImportItemHandler
implements IItemHandler {
    private final Map<Integer, List<ItemStack>> importItems = new HashMap<Integer, List<ItemStack>>();
    private final Map<Integer, List<Integer>> items = new HashMap<Integer, List<Integer>>();

    public void setImportItem(int index, List<ItemStack> importItem) {
        if (this.isEqual(this.importItems.get(index), importItem)) {
            return;
        }
        this.importItems.put(index, importItem);
        if (importItem != null) {
            this.items.put(index, new ArrayList<Integer>(Collections.nCopies(importItem.size(), 0)));
        }
    }

    private boolean isEqual(List<ItemStack> list1, List<ItemStack> list2) {
        if (list1 == null && list2 == null) {
            return true;
        }
        if (list1 == null || list2 == null) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            ItemStack item1 = list1.get(i);
            ItemStack item2 = list2.get(i);
            if (item1.m_41613_() != item2.m_41613_()) {
                return false;
            }
            if (item1.m_41720_() != item2.m_41720_()) {
                return false;
            }
            if (Objects.equals(item1.m_41783_(), item2.m_41783_())) continue;
            return false;
        }
        return true;
    }

    public boolean isImportValid(int index) {
        List<ItemStack> list = this.importItems.get(index);
        if (list == null) {
            return true;
        }
        List<Integer> counts = this.items.get(index);
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).m_41613_() == counts.get(i).intValue()) continue;
            return false;
        }
        return true;
    }

    public void consume(int index) {
        List<Integer> counts = this.items.get(index);
        if (counts == null) {
            return;
        }
        Collections.fill(counts, 0);
    }

    public int getSlots() {
        return 1;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        for (int i = 0; i < 4; ++i) {
            List<ItemStack> list = this.importItems.get(i);
            if (list == null) continue;
            for (ItemStack s : list) {
                if (stack.m_41720_() != s.m_41720_() || !Objects.equals(stack.m_41783_(), s.m_41783_())) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (!this.isItemValid(0, stack) || stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        stack = stack.m_41777_();
        for (int i = 0; i < 4; ++i) {
            List<ItemStack> list = this.importItems.get(i);
            if (list == null) continue;
            List<Integer> item = this.items.get(i);
            for (int j = 0; j < list.size(); ++j) {
                ItemStack s = list.get(j);
                if (stack.m_41720_() != s.m_41720_() || !Objects.equals(stack.m_41783_(), s.m_41783_())) continue;
                int amount = item.get(j);
                int needToBeAdded = s.m_41613_() - amount;
                if (stack.m_41613_() <= needToBeAdded) {
                    if (!simulate) {
                        item.set(j, amount + stack.m_41613_());
                    }
                    return ItemStack.f_41583_;
                }
                if (!simulate) {
                    item.set(j, amount + needToBeAdded);
                }
                stack.m_41774_(needToBeAdded);
            }
        }
        return stack;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        int count = 0;
        for (int i = 0; i < 4; ++i) {
            List<ItemStack> list = this.importItems.get(i);
            if (list == null) continue;
            for (ItemStack stack : list) {
                if (count >= stack.m_41613_()) continue;
                count = stack.m_41613_();
            }
        }
        return count;
    }

    public void save(CompoundTag tag) {
        ListTag list = new ListTag();
        for (int i = 0; i < 4; ++i) {
            CompoundTag compoundTag = new CompoundTag();
            List<ItemStack> stackList = this.importItems.get(i);
            compoundTag.m_128379_("IsNull", stackList == null);
            if (stackList == null) {
                list.add((Object)compoundTag);
                continue;
            }
            ListTag stackListTag = new ListTag();
            for (int j = 0; j < stackList.size(); ++j) {
                CompoundTag stackTag = new CompoundTag();
                ItemStack itemStack = stackList.get(j);
                stackTag.m_128365_("Item", (Tag)itemStack.serializeNBT());
                stackTag.m_128405_("Count", this.items.get(i).get(j).intValue());
                stackListTag.add((Object)stackTag);
            }
            compoundTag.m_128365_("Stacks", (Tag)stackListTag);
            list.add((Object)compoundTag);
        }
        tag.m_128365_("ItemHandler", (Tag)list);
    }

    public void load(CompoundTag tag) {
        this.importItems.clear();
        this.items.clear();
        ListTag list = tag.m_128437_("ItemHandler", 10);
        for (int i = 0; i < 4; ++i) {
            CompoundTag compoundTag = list.m_128728_(i);
            if (compoundTag.m_128471_("IsNull")) continue;
            ListTag stackListTag = compoundTag.m_128437_("Stacks", 10);
            ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
            ArrayList<Integer> items = new ArrayList<Integer>();
            for (int j = 0; j < stackListTag.size(); ++j) {
                CompoundTag stackTag = stackListTag.m_128728_(j);
                stackList.add(ItemStack.m_41712_((CompoundTag)stackTag.m_128469_("Item")));
                items.add(stackTag.m_128451_("Count"));
            }
            this.importItems.put(i, stackList);
            this.items.put(i, items);
        }
    }
}

