/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.helper;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class RecipeHelper {

    public static class FluidOutput {
        @NotNull
        public static JsonElement toJson(FluidStack fluid) {
            CompoundTag tag = fluid.writeToNBT(new CompoundTag());
            return (JsonElement)Dynamic.convert((DynamicOps)NbtOps.f_128958_, (DynamicOps)JsonOps.INSTANCE, (Object)tag);
        }

        @NotNull
        public static FluidStack fromJson(JsonObject parent, String key) {
            JsonElement elem = parent.get(key);
            Tag tag = (Tag)Dynamic.convert((DynamicOps)JsonOps.INSTANCE, (DynamicOps)NbtOps.f_128958_, (Object)elem);
            return FluidStack.loadFluidStackFromNBT((CompoundTag)((CompoundTag)tag));
        }

        public static void toNetwork(FriendlyByteBuf buffer, FluidStack fluid) {
            buffer.writeFluidStack(fluid);
        }

        @NotNull
        public static FluidStack fromNetwork(FriendlyByteBuf buffer) {
            return buffer.readFluidStack();
        }
    }

    public static class ItemOutput {
        @NotNull
        public static JsonElement toJson(ItemStack item) {
            CompoundTag tag = item.m_41739_(new CompoundTag());
            return (JsonElement)Dynamic.convert((DynamicOps)NbtOps.f_128958_, (DynamicOps)JsonOps.INSTANCE, (Object)tag);
        }

        @NotNull
        public static ItemStack fromJson(JsonObject parent, String key) {
            JsonElement elem = parent.get(key);
            Tag tag = (Tag)Dynamic.convert((DynamicOps)JsonOps.INSTANCE, (DynamicOps)NbtOps.f_128958_, (Object)elem);
            return ItemStack.m_41712_((CompoundTag)((CompoundTag)tag));
        }

        public static void toNetwork(FriendlyByteBuf buffer, ItemStack item) {
            buffer.m_130055_(item);
        }

        @NotNull
        public static ItemStack fromNetwork(FriendlyByteBuf buffer) {
            return buffer.m_130267_();
        }
    }

    public static class FluidInput {
        @NotNull
        public static JsonElement toJson(FluidStack fluid) {
            CompoundTag tag = fluid.writeToNBT(new CompoundTag());
            return (JsonElement)Dynamic.convert((DynamicOps)NbtOps.f_128958_, (DynamicOps)JsonOps.INSTANCE, (Object)tag);
        }

        @NotNull
        public static FluidStack fromJson(JsonObject parent, String key) {
            Tag tag = (Tag)Dynamic.convert((DynamicOps)JsonOps.INSTANCE, (DynamicOps)NbtOps.f_128958_, (Object)parent.get(key));
            return FluidStack.loadFluidStackFromNBT((CompoundTag)((CompoundTag)tag));
        }

        public static void toNetwork(FriendlyByteBuf buffer, FluidStack fluid) {
            buffer.writeFluidStack(fluid);
        }

        @NotNull
        public static FluidStack fromNetwork(FriendlyByteBuf buffer) {
            return buffer.readFluidStack();
        }
    }

    public static class IngredientInput {
        @NotNull
        public static JsonElement toJson(Ingredient ingredient) {
            return ingredient.m_43942_();
        }

        @NotNull
        public static Ingredient fromJson(JsonObject parent, String key) {
            return Ingredient.m_43917_((JsonElement)parent.get(key));
        }

        public static void toNetwork(FriendlyByteBuf buffer, Ingredient ingredient) {
            ingredient.m_43923_(buffer);
        }

        @NotNull
        public static Ingredient fromNetwork(FriendlyByteBuf buffer) {
            return Ingredient.m_43940_((FriendlyByteBuf)buffer);
        }
    }
}

