/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.recipes;

import com.mojang.datafixers.util.Either;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class WootContainer
implements Container {
    private final int size;
    private final NonNullList<Either<ItemStack, FluidStack>> ingredients;

    public WootContainer(int size) {
        this.size = size;
        this.ingredients = NonNullList.m_122780_((int)size, (Object)Either.left((Object)ItemStack.f_41583_));
    }

    @SafeVarargs
    public WootContainer(Either<ItemStack, FluidStack> ... ingredients) {
        this.size = ingredients.length;
        this.ingredients = NonNullList.m_122783_((Object)Either.left((Object)ItemStack.f_41583_), (Object[])ingredients);
    }

    public int m_6643_() {
        return this.size;
    }

    public boolean m_7983_() {
        return false;
    }

    public boolean isItemStack(int slot) {
        return slot >= 0 && slot < this.ingredients.size() && ((Either)this.ingredients.get(slot)).left().isPresent();
    }

    public boolean isFluidStack(int slot) {
        return slot >= 0 && slot < this.ingredients.size() && ((Either)this.ingredients.get(slot)).right().isPresent();
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        return slot >= 0 && slot < this.ingredients.size() ? ((Either)this.ingredients.get(slot)).left().orElse(ItemStack.f_41583_) : ItemStack.f_41583_;
    }

    public FluidStack getFluid(int slot) {
        return slot >= 0 && slot < this.ingredients.size() ? ((Either)this.ingredients.get(slot)).right().orElse(FluidStack.EMPTY) : FluidStack.EMPTY;
    }

    @NotNull
    public ItemStack m_7407_(int slot, int amount) {
        ItemStack itemStack;
        ItemStack itemStack2 = itemStack = this.isItemStack(slot) && amount > 0 ? ((ItemStack)((Either)this.ingredients.get(slot)).left().get()).m_41620_(amount) : ItemStack.f_41583_;
        if (!itemStack.m_41619_()) {
            this.m_6596_();
        }
        return itemStack;
    }

    public FluidStack removeFluid(int slot, int amount) {
        FluidStack fluidStack;
        FluidStack fluidStack2 = fluidStack = this.isFluidStack(slot) && amount > 0 ? (FluidStack)((Either)this.ingredients.get(slot)).right().get() : FluidStack.EMPTY;
        if (!fluidStack.isEmpty()) {
            fluidStack.setAmount(fluidStack.getAmount() - amount);
            this.m_6596_();
        }
        return fluidStack;
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        if (this.isItemStack(slot)) {
            ItemStack itemstack = (ItemStack)((Either)this.ingredients.get(slot)).left().get();
            if (!itemstack.m_41619_()) {
                this.ingredients.set(0, (Object)Either.left((Object)ItemStack.f_41583_));
            }
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    public FluidStack removeFluidNoUpdate(int slot) {
        if (this.isFluidStack(slot)) {
            FluidStack fluidStack = (FluidStack)((Either)this.ingredients.get(slot)).right().get();
            if (!fluidStack.isEmpty()) {
                this.ingredients.set(0, (Object)Either.right((Object)FluidStack.EMPTY));
            }
            return fluidStack;
        }
        return FluidStack.EMPTY;
    }

    public void m_6836_(int slot, @NotNull ItemStack stack) {
        this.ingredients.set(slot, (Object)Either.left((Object)stack));
        if (!stack.m_41619_() && stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public void setFluid(int slot, FluidStack stack) {
        this.ingredients.set(slot, (Object)Either.right((Object)stack));
        this.m_6596_();
    }

    public void m_6596_() {
    }

    public boolean m_6542_(@NotNull Player player) {
        return true;
    }

    public void m_6211_() {
        this.ingredients.clear();
        this.m_6596_();
    }
}

