/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.render;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import wootrevived.woot.Woot;
import wootrevived.woot.mixins.impl.GuiGraphicsMixin;
import wootrevived.woot.util.common.MachineSide;
import wootrevived.woot.util.common.MachineSideProperty;
import wootrevived.woot.util.common.RedstoneMode;
import wootrevived.woot.util.render.WootButton;
import wootrevived.woot.util.render.WootContainerMenu;
import wootrevived.woot.util.render.WootSlot;
import wootrevived.woot.util.render.WootStyles;
import wootrevived.woot.util.render.buttons.WootRedstoneButton;
import wootrevived.woot.util.render.buttons.WootSideButton;
import wootrevived.woot.util.render.buttons.WootSidePropertyButton;

public abstract class WootContainerScreen<T extends WootContainerMenu>
extends AbstractContainerScreen<T> {
    public static final ResourceLocation GUI = Woot.location("textures/gui/atlas.png");
    protected static final int GUI_XSIZE = 176;
    protected static final int GUI_YSIZE = 184;
    private int xSides = 8;
    private final int ySides = 84;
    private final List<WootSideButton> sideButtons = new ArrayList<WootSideButton>();
    private int activeSideButton = -1;
    private final Direction machineFacing;
    private final List<WootButton> buttons = new ArrayList<WootButton>();
    private final Map<MachineSide, WootSidePropertyButton> propertyButtons = Maps.newEnumMap(MachineSide.class);

    public void addRenderableWidget(WootButton button) {
        this.buttons.add(button);
        this.m_7787_((GuiEventListener)button);
    }

    public WootContainerScreen(T container, Inventory inventory, Component title) {
        super(container, inventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 184;
        this.machineFacing = ((WootContainerMenu)((Object)container)).getMachineFacing();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.buttons.clear();
        this.addRenderableWidget(new WootRedstoneButton(this.f_97735_ + 154, this.f_97736_ + 84, ((WootContainerMenu)this.f_97732_).getRedstoneMode(), button -> {
            RedstoneMode mode = button.nextMode();
            ((WootContainerMenu)this.f_97732_).setRedstoneMode(mode);
        }));
        this.xSides = 8;
        this.sideButtons.clear();
        this.initButtons();
        if (this.activeSideButton != -1) {
            this.sideButtons.get((int)this.activeSideButton).isViewActive = true;
        }
        this.createPropertyButton(81, 105, MachineSide.TOP);
        this.createPropertyButton(65, 121, MachineSide.LEFT);
        this.createPropertyButton(81, 121, MachineSide.FRONT);
        this.createPropertyButton(97, 121, MachineSide.RIGHT);
        this.createPropertyButton(81, 137, MachineSide.BOTTOM);
        this.createPropertyButton(97, 137, MachineSide.BACK);
    }

    protected void createPropertyButton(int x, int y, MachineSide side) {
        MachineSideProperty property = MachineSideProperty.ENABLED;
        if (this.activeSideButton != -1) {
            property = ((WootContainerMenu)this.f_97732_).getMachineSideProperties(this.sideButtons.get((int)this.activeSideButton).propertiesIndex).get((Object)side);
        }
        WootSidePropertyButton button = new WootSidePropertyButton(this.f_97735_ + x, this.f_97736_ + y, side, property, this.machineFacing, btn -> {
            Map<MachineSide, MachineSideProperty> properties = ((WootContainerMenu)this.f_97732_).getMachineSideProperties(this.sideButtons.get((int)this.activeSideButton).propertiesIndex);
            properties.put(side, btn.nextProperty());
            ((WootContainerMenu)this.f_97732_).setMachineSideProperties();
        });
        button.f_93623_ = this.activeSideButton != -1;
        this.propertyButtons.put(side, button);
        this.m_7787_((GuiEventListener)button);
    }

    protected abstract void initButtons();

    public void setButtonActive(WootSideButton button) {
        if (this.activeSideButton == button.index) {
            this.activeSideButton = -1;
            button.isViewActive = false;
            for (MachineSide side : MachineSide.values()) {
                this.propertyButtons.get((Object)((Object)side)).f_93623_ = false;
            }
        } else {
            if (this.activeSideButton != -1) {
                this.sideButtons.get((int)this.activeSideButton).isViewActive = false;
            }
            this.activeSideButton = button.index;
            button.isViewActive = true;
            Map<MachineSide, MachineSideProperty> properties = ((WootContainerMenu)this.f_97732_).getMachineSideProperties(button.propertiesIndex);
            for (MachineSide side : MachineSide.values()) {
                this.propertyButtons.get((Object)((Object)side)).f_93623_ = true;
                this.propertyButtons.get((Object)((Object)side)).property = properties.get((Object)side);
            }
        }
    }

    public void m_88315_(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        for (Slot slot : ((WootContainerMenu)this.f_97732_).f_38839_) {
            if (!(slot instanceof WootSlot)) continue;
            WootSlot wootSlot = (WootSlot)slot;
            wootSlot.setActive(this.activeSideButton == -1);
        }
        super.m_88315_(gui, mouseX, mouseY, partialTicks);
        super.m_280072_(gui, mouseX, mouseY);
        this.m_280072_(gui, mouseX, mouseY);
        for (WootButton button : this.buttons) {
            button.m_88315_(gui, mouseX, mouseY, partialTicks);
        }
        if (this.activeSideButton != -1) {
            this.renderInventoryHoverBox(gui, 7, 101, 169, 155);
            for (MachineSide side : MachineSide.values()) {
                WootSidePropertyButton button = this.propertyButtons.get((Object)side);
                button.m_88315_(gui, mouseX, mouseY, partialTicks);
            }
        }
    }

    private void renderInventoryHoverBox(@NotNull GuiGraphics gui, int minX, int minY, int maxX, int maxY) {
        gui.m_280509_((minX += this.f_97735_) + 1, (minY += this.f_97736_) + 1, (maxX += this.f_97735_) - 1, (maxY += this.f_97736_) - 1, -2368549);
        gui.m_280509_(minX, minY, maxX - 1, minY + 1, -13224393);
        gui.m_280509_(minX, minY, minX + 1, maxY - 1, -13224393);
        gui.m_280509_(minX + 1, maxY - 1, maxX, maxY, -1);
        gui.m_280509_(maxX - 1, minY + 1, maxX, maxY, -1);
    }

    protected void m_280003_(@NotNull GuiGraphics gui, int mouseX, int mouseY) {
        int titleX = 1 + (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
        gui.m_280614_(this.f_96547_, this.f_96539_, titleX, 6, 0x404040, false);
    }

    protected void m_7286_(@NotNull GuiGraphics gui, float partialTicks, int mouseX, int mouseY) {
        this.m_280273_(gui);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        PoseStack pose = gui.m_280168_();
        pose.m_85836_();
        pose.m_252880_((float)x, (float)y, 0.0f);
        gui.m_280218_(GUI, 0, 0, 0, 0, this.f_97726_, this.f_97727_);
        this.renderMenuBackground(gui);
        this.renderState(gui);
        pose.m_85849_();
    }

    protected abstract void renderMenuBackground(@NotNull GuiGraphics var1);

    protected abstract void renderState(@NotNull GuiGraphics var1);

    public static void renderSlot(@NotNull GuiGraphics gui, int x, int y, int color) {
        WootContainerScreen.stroke(gui, x - 1, y - 1, x + 18, y + 18, color & 0x2FFFFFFF);
        gui.m_280218_(GUI, x, y, 228, 0, 18, 18);
        gui.m_280509_(x + 1, y + 1, x + 17, y + 17, color & 0x4FFFFFFF);
    }

    public static void renderVanillaSlot(@NotNull GuiGraphics gui, int x, int y) {
        gui.m_280218_(GUI, x, y, 7, 101, 18, 18);
    }

    public void createSlotSideButton(int x, int y, int color, int propertiesIndex, Component name) {
        WootSideButton button = new WootSideButton(this.sideButtons.size(), this.f_97735_ + this.xSides, this.f_97736_ + 84, this.f_97735_ + x - 2, this.f_97736_ + y - 2, 21, 21, color, propertiesIndex, name, this::setButtonActive);
        this.sideButtons.add(button);
        this.addRenderableWidget(button);
        this.xSides += 18;
    }

    public static void renderEnergyBg(@NotNull GuiGraphics gui, int x, int y) {
        gui.m_280218_(GUI, x, y, 177, 0, 18, 56);
    }

    public static void renderEnergy(@NotNull GuiGraphics gui, int x, int y, int fill, int capacity) {
        int fillHeight = Mth.m_14045_((int)(fill * 50 / capacity), (int)0, (int)50);
        int fillY = 50 - fillHeight;
        gui.m_280218_(GUI, x + 3, y + fillY + 3, 196, 3 + fillY, 12, fillHeight);
    }

    public void renderEnergyTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY, int x, int y, int fill, int capacity) {
        if (this.m_6774_(x, y, 18, 56, mouseX, mouseY)) {
            WootContainerScreen._renderEnergyTooltip(gui, mouseX, mouseY, x, y, fill, capacity, true, true);
        }
    }

    public static void _renderEnergyTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY, int x, int y, int fill, int capacity, boolean skipHover, boolean showCapacity) {
        if (skipHover || WootContainerScreen._isHovering(x, y, 18, 56, mouseX, mouseY)) {
            List<MutableComponent> tooltip = showCapacity ? List.of(Component.m_237115_((String)"info.woot_revived.power").m_7220_((Component)Component.m_237113_((String)":")).m_6270_(WootStyles.MACHINE_STYLE), Component.m_237113_((String)WootContainerScreen.formatInteger(fill)).m_7220_((Component)Component.m_237113_((String)"/").m_6270_(WootStyles.MACHINE_STYLE)).m_130946_(WootContainerScreen.formatInteger(capacity)).m_7220_((Component)Component.m_237113_((String)" FE").m_6270_(WootStyles.UNIT_STYLE))) : List.of(Component.m_237115_((String)"info.woot_revived.power").m_7220_((Component)Component.m_237113_((String)":")).m_6270_(WootStyles.MACHINE_STYLE), Component.m_237113_((String)WootContainerScreen.formatInteger(fill)).m_7220_((Component)Component.m_237113_((String)" FE").m_6270_(WootStyles.UNIT_STYLE)));
            gui.m_280677_(WootContainerScreen.getFont(), tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    public static void renderFluidBg(@NotNull GuiGraphics gui, int x, int y) {
        gui.m_280218_(GUI, x, y, 209, 0, 18, 56);
    }

    public static void renderFluid(@NotNull GuiGraphics gui, int x, int y, FluidStack fluid, int capacity) {
        if (fluid == null || fluid.isEmpty()) {
            return;
        }
        int fillHeight = Mth.m_14045_((int)(fluid.getAmount() * 50 / capacity), (int)0, (int)50);
        int fillY = 50 - fillHeight;
        IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((FluidType)fluid.getFluid().getFluidType());
        TextureAtlasSprite texture = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidTypeExtensions.getStillTexture());
        WootContainerScreen.renderTiledFluidTextureAtlas(gui, texture, x + 3, y + fillY + 3, 12, fillHeight, fluidTypeExtensions.getTintColor(), false);
        gui.m_280218_(GUI, x + 3, y + 3, 212, 3, 12, 50);
    }

    public void createFluidSideButton(int x, int y, int color, int propertiesIndex, Component name) {
        WootSideButton button = new WootSideButton(this.sideButtons.size(), this.f_97735_ + this.xSides, this.f_97736_ + 84, this.f_97735_ + x - 2, this.f_97736_ + y - 2, 21, 59, color, propertiesIndex, name, this::setButtonActive);
        this.sideButtons.add(button);
        this.addRenderableWidget(button);
        this.xSides += 18;
    }

    public void renderFluidTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY, int x, int y, FluidStack fluid, int capacity) {
        if (this.m_6774_(x, y, 18, 56, mouseX, mouseY)) {
            WootContainerScreen._renderFluidTooltip(gui, mouseX, mouseY, x, y, fluid, capacity, true, true);
        }
    }

    public static void _renderFluidTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY, int x, int y, FluidStack fluid, int capacity, boolean skipHover, boolean showCapacity) {
        if (skipHover || WootContainerScreen._isHovering(x, y, 18, 56, mouseX, mouseY)) {
            List<MutableComponent> tooltip = showCapacity ? List.of(Component.m_237119_().m_7220_((Component)Component.m_237115_((String)"info.woot_revived.fluid").m_7220_((Component)Component.m_237113_((String)": ")).m_6270_(WootStyles.MACHINE_STYLE)).m_7220_((Component)(fluid != null && !fluid.isEmpty() ? fluid.getDisplayName() : Component.m_237115_((String)"info.woot_revived.empty"))), Component.m_237119_().m_7220_((Component)Component.m_237115_((String)"info.woot_revived.amount").m_7220_((Component)Component.m_237113_((String)": ")).m_6270_(WootStyles.MACHINE_STYLE)).m_130946_(WootContainerScreen.formatInteger(fluid.getAmount())).m_7220_((Component)Component.m_237113_((String)"/").m_6270_(WootStyles.MACHINE_STYLE)).m_130946_(WootContainerScreen.formatInteger(capacity)).m_7220_((Component)Component.m_237113_((String)"mB").m_6270_(WootStyles.UNIT_STYLE))) : List.of(Component.m_237119_().m_7220_((Component)Component.m_237115_((String)"info.woot_revived.fluid").m_7220_((Component)Component.m_237113_((String)": ")).m_6270_(WootStyles.MACHINE_STYLE)).m_7220_((Component)(fluid != null && !fluid.isEmpty() ? fluid.getDisplayName() : Component.m_237115_((String)"info.woot_revived.empty"))), Component.m_237119_().m_7220_((Component)Component.m_237115_((String)"info.woot_revived.amount").m_7220_((Component)Component.m_237113_((String)": ")).m_6270_(WootStyles.MACHINE_STYLE)).m_130946_(WootContainerScreen.formatInteger(fluid.getAmount())).m_7220_((Component)Component.m_237113_((String)"mB").m_6270_(WootStyles.UNIT_STYLE)));
            gui.m_280677_(WootContainerScreen.getFont(), tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    public static void renderTiledFluidTextureAtlas(@NotNull GuiGraphics guiGraphics, TextureAtlasSprite sprite, int x, int y, int width, int height, int color, boolean enableBlend) {
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.m_247685_());
        if (enableBlend) {
            RenderSystem.enableBlend();
        } else {
            RenderSystem.disableBlend();
        }
        int spriteWidth = sprite.m_245424_().m_246492_();
        int spriteHeight = sprite.m_245424_().m_245330_();
        for (int i = 0; i < width; i += spriteWidth) {
            for (int j = 0; j < height; j += spriteHeight) {
                int drawWidth = Math.min(width - i, spriteWidth);
                int drawHeight = Math.min(height - j, spriteHeight);
                WootContainerScreen.renderScaledTexturedModelRectFromIcon(guiGraphics, sprite, x + i, y + j, drawWidth, drawHeight, color);
            }
        }
        if (enableBlend) {
            RenderSystem.disableBlend();
        }
    }

    public static void renderScaledTexturedModelRectFromIcon(@NotNull GuiGraphics guiGraphics, TextureAtlasSprite icon, int x, int y, int width, int height, int color) {
        if (icon == null) {
            return;
        }
        float minU = icon.m_118409_();
        float maxU = icon.m_118410_();
        float minV = icon.m_118411_();
        float maxV = icon.m_118412_();
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        Matrix4f matrix = guiGraphics.m_280168_().m_85850_().m_252922_();
        builder.m_252986_(matrix, (float)x, (float)(y + height), 0.0f).m_7421_(minU, minV + (maxV - minV) * (float)height / 16.0f).m_85950_(red, green, blue, 1.0f).m_5752_();
        builder.m_252986_(matrix, (float)(x + width), (float)(y + height), 0.0f).m_7421_(minU + (maxU - minU) * (float)width / 16.0f, minV + (maxV - minV) * (float)height / 16.0f).m_85950_(red, green, blue, 1.0f).m_5752_();
        builder.m_252986_(matrix, (float)(x + width), (float)y, 0.0f).m_7421_(minU + (maxU - minU) * (float)width / 16.0f, minV).m_85950_(red, green, blue, 1.0f).m_5752_();
        builder.m_252986_(matrix, (float)x, (float)y, 0.0f).m_7421_(minU, minV).m_85950_(red, green, blue, 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
    }

    public static void renderProgressArrowBg(@NotNull GuiGraphics gui, int x, int y) {
        gui.m_280218_(GUI, x, y, 228, 19, 22, 15);
    }

    public static void renderProgressArrow(@NotNull GuiGraphics gui, int x, int y, int progress) {
        int fillWidth = Mth.m_14045_((int)(progress * 22 / 100), (int)0, (int)22);
        gui.m_280218_(GUI, x, y, 228, 35, fillWidth, 16);
    }

    public void renderProgressArrowTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY, int x, int y, int progress, float eta, int usage) {
        this.renderProgressTooltip(gui, mouseX, mouseY, x, y, 22, 16, progress, eta, usage);
    }

    public static void _renderProgressArrowTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY, int x, int y, int progress, float eta, int usage, boolean skipHover) {
        WootContainerScreen._renderProgressTooltip(gui, mouseX, mouseY, x, y, 22, 16, progress, eta, usage, skipHover);
    }

    public void renderProgressTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY, int x, int y, int width, int height, int progress, float eta, int usage) {
        if (this.m_6774_(x, y, width, height, mouseX, mouseY)) {
            WootContainerScreen._renderProgressTooltip(gui, mouseX, mouseY, x, y, width, height, progress, eta, usage, true);
        }
    }

    public static void _renderProgressTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY, int x, int y, int width, int height, int progress, float eta, int usage, boolean skipHover) {
        if (skipHover || WootContainerScreen._isHovering(x, y, width, height, mouseX, mouseY)) {
            List<MutableComponent> tooltip = List.of(Component.m_237119_().m_7220_((Component)Component.m_237115_((String)"info.woot_revived.progress").m_7220_((Component)Component.m_237113_((String)": ")).m_6270_(WootStyles.MACHINE_STYLE)).m_130946_(WootContainerScreen.formatInteger(progress)).m_7220_((Component)Component.m_237113_((String)"/").m_6270_(WootStyles.MACHINE_STYLE)).m_7220_((Component)Component.m_237113_((String)"100")), Component.m_237119_().m_7220_((Component)Component.m_237115_((String)"info.woot_revived.eta").m_7220_((Component)Component.m_237113_((String)": ")).m_6270_(WootStyles.MACHINE_STYLE)).m_130946_(String.format("%.1f", Float.valueOf(eta))).m_7220_((Component)Component.m_237113_((String)"s").m_6270_(WootStyles.UNIT_STYLE)), Component.m_237119_().m_7220_((Component)Component.m_237115_((String)"info.woot_revived.usage").m_7220_((Component)Component.m_237113_((String)": ")).m_6270_(WootStyles.MACHINE_STYLE)).m_130946_(WootContainerScreen.formatInteger(usage)).m_7220_((Component)Component.m_237113_((String)" FE").m_6270_(WootStyles.UNIT_STYLE)).m_7220_((Component)Component.m_237113_((String)"/").m_6270_(WootStyles.MACHINE_STYLE)).m_7220_((Component)Component.m_237113_((String)"t").m_6270_(WootStyles.UNIT_STYLE)));
            gui.m_280677_(WootContainerScreen.getFont(), tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    public static void renderColorBarBg(@NotNull GuiGraphics gui, int x, int y, float[] color) {
        gui.m_280218_(GUI, x, y, 177, 57, 56, 11);
        ((GuiGraphicsMixin)gui).woot$innerBlit(GUI, x + 3, x + 53, y + 3, y + 8, 0, 0.703125f, 0.8984375f, 0.26953125f, 0.2890625f, color[0], color[1], color[2], 1.0f);
    }

    public static void renderColorBar(@NotNull GuiGraphics gui, int x, int y, int fill, int capacity, float[] color) {
        int fillWidth = Mth.m_14045_((int)(fill * 50 / capacity), (int)0, (int)50);
        ((GuiGraphicsMixin)gui).woot$innerBlit(GUI, x + 3, x + 3 + fillWidth, y + 3, y + 8, 0, 0.703125f, (180.0f + (float)fillWidth) / 256.0f, 0.29296875f, 0.3125f, color[0], color[1], color[2], 1.0f);
    }

    public void renderColorBarTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY, int x, int y, int fill, int capacity, MutableComponent colorName) {
        if (this.m_6774_(x + 1, y + 1, 54, 9, mouseX, mouseY)) {
            WootContainerScreen._renderColorBarTooltip(gui, mouseX, mouseY, x, y, fill, capacity, colorName, true, true);
        }
    }

    public static void _renderColorBarTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY, int x, int y, int fill, int capacity, MutableComponent colorName, boolean skipHover, boolean showCapacity) {
        if (skipHover || WootContainerScreen._isHovering(x + 1, y + 1, 54, 9, mouseX, mouseY)) {
            List<MutableComponent> tooltip = showCapacity ? List.of(colorName.m_7220_((Component)Component.m_237113_((String)": ")).m_6270_(WootStyles.MACHINE_STYLE), Component.m_237113_((String)WootContainerScreen.formatInteger(fill)).m_7220_((Component)Component.m_237113_((String)"/").m_6270_(WootStyles.MACHINE_STYLE)).m_130946_(WootContainerScreen.formatInteger(capacity)).m_7220_((Component)Component.m_237113_((String)"mB").m_6270_(WootStyles.UNIT_STYLE))) : List.of(colorName.m_7220_((Component)Component.m_237113_((String)": ")).m_6270_(WootStyles.MACHINE_STYLE), Component.m_237113_((String)WootContainerScreen.formatInteger(fill)).m_7220_((Component)Component.m_237113_((String)"mB").m_6270_(WootStyles.UNIT_STYLE)));
            gui.m_280677_(WootContainerScreen.getFont(), tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    public static void stroke(@NotNull GuiGraphics gui, int minX, int minY, int maxX, int maxY, int color) {
        gui.m_280656_(minX, maxX, minY, color);
        gui.m_280315_(maxX, minY, maxY, color);
        gui.m_280656_(maxX, minX, maxY, color);
        gui.m_280315_(minX, maxY, minY, color);
    }

    public static String formatInteger(int val) {
        return String.format(Locale.US, "%,d", val).replace(",", " ");
    }

    public static String formatFloat(float val) {
        return String.format(Locale.US, "%,.1f", Float.valueOf(val)).replace(",", " ");
    }

    public static Font getFont() {
        return Minecraft.m_91087_().f_91062_;
    }

    public static boolean _isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        return mouseX >= (double)(x - 1) && mouseX < (double)(x + width + 1) && mouseY >= (double)(y - 1) && mouseY < (double)(y + height + 1);
    }

    public static void renderPlus(@NotNull GuiGraphics gui, int x, int y) {
        gui.m_280218_(GUI, x, y, 234, 57, 13, 14);
    }
}

