/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.render;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import wootrevived.woot.events.client.GlobalClientTicker;

public class WootEntityRenderer {
    public static void render(@NotNull GuiGraphics gui, int x, int y, @NotNull LivingEntity entity, double size, double padding, float max_entity_size) {
        EntityRenderer renderer = Minecraft.m_91087_().m_91290_().m_114382_((Entity)entity);
        if (renderer == null) {
            return;
        }
        PoseStack pose = gui.m_280168_();
        pose.m_85836_();
        pose.m_252880_((float)x, (float)y, 0.0f);
        Matrix4f matrix = pose.m_85850_().m_252922_();
        Vector3f poseScale = new Vector3f();
        Vector3f pos = new Vector3f();
        matrix.getScale(poseScale);
        matrix.transformPosition(pos);
        float width = max_entity_size / entity.m_20205_();
        float height = max_entity_size / entity.m_20206_();
        float scale = Math.min(width, height);
        scale = Math.min(scale, max_entity_size);
        pose.m_85837_(size / 2.0 + padding, size / 2.0 - padding * 2.0 + (double)(entity.m_20206_() * scale), 64.0);
        WootEntityRenderer.patchedScale(pose, 1.0f, 1.0f, -1.0f);
        pose.m_252781_(Axis.f_252436_.m_252977_((float)(GlobalClientTicker.tickCounter * 4 % 360)));
        pose.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        pose.m_85841_(scale, scale, scale);
        Window window = Minecraft.m_91087_().m_91268_();
        double windowScale = (double)window.m_85441_() / (double)window.m_85445_();
        RenderSystem.enableScissor((int)((int)(((double)pos.x + padding * (double)poseScale.x) * windowScale)), (int)((int)((double)window.m_85442_() - ((double)pos.y + (size + padding) * (double)poseScale.y) * windowScale)), (int)((int)Math.ceil(size * windowScale * (double)poseScale.x)), (int)((int)Math.ceil(size * windowScale * (double)poseScale.y)));
        Tesselator tesselator = Tesselator.m_85913_();
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)tesselator.m_85915_());
        Lighting.m_84930_();
        renderer.m_7392_((Entity)entity, 0.0f, 0.0f, pose, (MultiBufferSource)bufferSource, LightTexture.m_109885_((int)15, (int)15));
        bufferSource.m_173043_();
        RenderSystem.disableScissor();
        Lighting.m_84931_();
        pose.m_85849_();
    }

    public static void patchedScale(PoseStack poseStack, float x, float y, float z) {
        PoseStack.Pose pose = poseStack.m_85850_();
        pose.m_252922_().scale(x, y, z);
        float fx = 1.0f / x;
        float fy = 1.0f / y;
        float fz = 1.0f / z;
        float fw = Mth.m_14199_((float)Math.abs(fx * fy * fz));
        pose.m_252943_().scale(fw * fx, fw * fy, fw * fz);
    }
}

