/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.render.guide;

import guideme.document.LytRect;
import guideme.document.block.LytBlock;
import guideme.document.interaction.GuideTooltip;
import guideme.document.interaction.InteractiveElement;
import guideme.layout.LayoutContext;
import guideme.render.RenderContext;
import guideme.scene.level.GuidebookLevel;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import wootrevived.api.WootFactoryMob;
import wootrevived.woot.util.helper.SerializeEntityNBTHelper;
import wootrevived.woot.util.render.WootEntityRenderer;
import wootrevived.woot.util.render.guide.EntityTooltip;

public class LytEntity
extends LytBlock
implements InteractiveElement {
    private static double BOX_SIZE = 36.0;
    private static double BOX_PADDING = 3.0;
    private static float MAX_ENTITY_BOX_SIZE = 20.0f;
    private final WootFactoryMob<?> mob;
    private final LivingEntity entity;
    private final GuidebookLevel level;

    public LytEntity(WootFactoryMob<?> mob, LivingEntity entity, GuidebookLevel level) {
        this.mob = mob;
        this.entity = entity;
        this.level = level;
    }

    protected LytRect computeLayout(LayoutContext context, int x, int y, int availableWidth) {
        return new LytRect(x, y, 42, 42);
    }

    protected void onLayoutMoved(int deltaX, int deltaY) {
    }

    public void renderBatch(RenderContext renderContext, MultiBufferSource multiBufferSource) {
    }

    public void render(RenderContext renderContext) {
        renderContext.renderPanel(this.bounds);
        WootEntityRenderer.render(renderContext.guiGraphics(), this.bounds.x(), this.bounds.y(), this.entity, BOX_SIZE, BOX_PADDING, MAX_ENTITY_BOX_SIZE);
    }

    public Optional<GuideTooltip> getTooltip(float x, float y) {
        return Optional.of(new EntityTooltip(this.mob, SerializeEntityNBTHelper.serialize((Entity)this.entity), this.level));
    }
}

