/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.render.guide;

import guideme.document.LytRect;
import guideme.document.block.LytBlock;
import guideme.document.interaction.GuideTooltip;
import guideme.document.interaction.InteractiveElement;
import guideme.layout.LayoutContext;
import guideme.render.RenderContext;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraftforge.fluids.FluidStack;
import wootrevived.woot.util.render.WootContainerScreen;
import wootrevived.woot.util.render.guide.FluidTooltip;

public class LytFluid
extends LytBlock
implements InteractiveElement {
    private final FluidStack stack;
    private final int capacity;

    public LytFluid(FluidStack stack, int capacity) {
        this.stack = stack;
        this.capacity = capacity;
    }

    protected LytRect computeLayout(LayoutContext context, int x, int y, int availableWidth) {
        return new LytRect(x, y, 18, 56);
    }

    protected void onLayoutMoved(int deltaX, int deltaY) {
    }

    public void renderBatch(RenderContext context, MultiBufferSource buffers) {
    }

    public void render(RenderContext context) {
        int x = this.bounds.x();
        int y = this.bounds.y();
        GuiGraphics gui = context.guiGraphics();
        WootContainerScreen.renderFluidBg(gui, x, y);
        WootContainerScreen.renderFluid(gui, x, y, this.stack, this.capacity);
    }

    public Optional<GuideTooltip> getTooltip(float x, float y) {
        if (this.stack.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new FluidTooltip(this.stack));
    }
}

