/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.api;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import wootrevived.api.enums.Tier;
import wootrevived.api.interfaces.WootDropsProperties;

public class WootFactoryMob<T extends Entity> {
    private final Properties properties;
    protected final EntityType<T> entityType;

    public WootFactoryMob(EntityType<T> entityType, Properties properties) {
        this.entityType = entityType;
        this.properties = properties;
        if (properties.vitalityCost == -1) {
            properties.vitalityCost = properties.tier.defaultVitalityCost();
        }
    }

    public MutableComponent getDisplayName(CompoundTag mobTag, HolderLookup.Provider lookupProvider) {
        return Component.translatable((String)this.entityType.getDescriptionId());
    }

    public MutableComponent getTooltipKillName(CompoundTag mobTag, HolderLookup.Provider lookupProvider) {
        return this.getDisplayName(mobTag, lookupProvider);
    }

    public CompoundTag saveTag(CompoundTag mobTag, HolderLookup.Provider lookupProvider) {
        CompoundTag tag = new CompoundTag();
        tag.putString("id", mobTag.getString("id"));
        return tag;
    }

    public boolean isSame(CompoundTag shardTag, CompoundTag mobTag, HolderLookup.Provider lookupProvider) {
        return shardTag.getString("id").equals(mobTag.getString("id"));
    }

    @ApiStatus.AvailableSince(value="1.0.4")
    @Nullable
    public LivingEntity loadEntity(CompoundTag mobTag, ServerLevel level) {
        if (level == null || !mobTag.contains("id")) {
            return null;
        }
        Entity entity = EntityType.loadEntityRecursive((CompoundTag)mobTag, (Level)level, e -> e);
        if (!(entity instanceof LivingEntity)) {
            return null;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            MobSpawnEvent.FinalizeSpawn event = new MobSpawnEvent.FinalizeSpawn(mob, (ServerLevelAccessor)level, 0.0, 0.0, 0.0, level.getCurrentDifficultyAt(BlockPos.ZERO), MobSpawnType.SPAWNER, null, null, null);
            NeoForge.EVENT_BUS.post((Event)event);
            mob.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(BlockPos.ZERO), MobSpawnType.SPAWNER, null, null);
        }
        return livingEntity;
    }

    public void modifyDrops(Phase phase, WootDropsProperties properties) {
    }

    public List<ItemStack> getImportItems(CompoundTag mobTag, HolderLookup.Provider lookupProvider) {
        return List.of();
    }

    public List<FluidStack> getImportFluids(CompoundTag mobTag, HolderLookup.Provider lookupProvider) {
        return List.of();
    }

    public final EntityType<T> getEntityType() {
        return this.entityType;
    }

    public final boolean isBlacklisted() {
        return this.properties.blacklist;
    }

    public final boolean isSimulationDisabled() {
        return this.properties.disabledSimulation;
    }

    public final int getSpawnTickRate() {
        return this.properties.rate;
    }

    public final int getVitalityFuelCost() {
        return this.properties.vitalityCost;
    }

    public final Tier getTier() {
        return this.properties.tier;
    }

    public static final class Properties {
        boolean blacklist = false;
        boolean disabledSimulation = false;
        int rate = 300;
        int vitalityCost = -1;
        Tier tier = Tier.TIER_1;

        public Properties blacklist(boolean isBlacklisted) {
            this.blacklist = isBlacklisted;
            return this;
        }

        public Properties disabledSimulation(boolean isSimulationDisabled) {
            this.disabledSimulation = isSimulationDisabled;
            return this;
        }

        public Properties rate(int spawnTickRate) {
            this.rate = Math.max(0, spawnTickRate);
            return this;
        }

        public Properties vitalityCost(int vitalityCost) {
            this.vitalityCost = Math.max(0, vitalityCost);
            return this;
        }

        public Properties tier(Tier tier) {
            if (tier == Tier.INVALID) {
                return this;
            }
            this.tier = tier;
            return this;
        }
    }

    public static enum Phase {
        BEFORE_DROP_CALLBACKS,
        AFTER_DROP_CALLBACKS,
        AFTER_UPGRADES;


        public boolean isBeforeDropCallback() {
            return this == BEFORE_DROP_CALLBACKS;
        }

        public boolean isAfterDropCallback() {
            return this == AFTER_DROP_CALLBACKS;
        }

        public boolean isAfterUpgrades() {
            return this == AFTER_UPGRADES;
        }
    }
}

