/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.cell;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.blocks.cell.CellBlockEntity;
import wootrevived.woot.config.CellConfig;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.util.block.FactoryBlockBase;
import wootrevived.woot.util.render.WootContainerScreen;
import wootrevived.woot.util.render.WootStyles;

public class CellBlock
extends FactoryBlockBase {
    protected StateDefinition<Block, BlockState> cellStateDefinition;

    public CellBlock(Supplier<BlockEntityType<?>> entity) {
        super(entity, BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.METAL).strength(3.5f));
        StateDefinition.Builder stateDefinitionBuilder = new StateDefinition.Builder((Object)this);
        this.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)stateDefinitionBuilder);
        this.cellStateDefinition = stateDefinitionBuilder.create(Block::defaultBlockState, State::new);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(true)));
    }

    @NotNull
    public StateDefinition<Block, BlockState> getStateDefinition() {
        return this.cellStateDefinition;
    }

    @Override
    public boolean verifyItem(Item item) {
        return item == BlocksRegistry.COPPER_CELL_BLOCK_ITEM.get() || item == BlocksRegistry.IRON_CELL_BLOCK_ITEM.get() || item == BlocksRegistry.GOLD_CELL_BLOCK_ITEM.get() || item == BlocksRegistry.DIAMOND_CELL_BLOCK_ITEM.get() || item == BlocksRegistry.NETHERITE_CELL_BLOCK_ITEM.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(@NotNull ItemStack stack, @Nullable BlockGetter block, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.appendHoverText(stack, block, tooltip, flag);
        int capacity = 0;
        if (this.entity.get() == BlocksRegistry.COPPER_CELL_BLOCK_ENTITY.get()) {
            capacity = (Integer)CellConfig.COPPER_CAPACITY.get();
        } else if (this.entity.get() == BlocksRegistry.IRON_CELL_BLOCK_ENTITY.get()) {
            capacity = (Integer)CellConfig.IRON_CAPACITY.get();
        } else if (this.entity.get() == BlocksRegistry.GOLD_CELL_BLOCK_ENTITY.get()) {
            capacity = (Integer)CellConfig.GOLD_CAPACITY.get();
        } else if (this.entity.get() == BlocksRegistry.DIAMOND_CELL_BLOCK_ENTITY.get()) {
            capacity = (Integer)CellConfig.DIAMOND_CAPACITY.get();
        } else if (this.entity.get() == BlocksRegistry.NETHERITE_CELL_BLOCK_ENTITY.get()) {
            capacity = (Integer)CellConfig.NETHERITE_CAPACITY.get();
        }
        CompoundTag tag = stack.getTagElement("BlockEntityTag");
        if (tag != null && tag.contains("InputTank")) {
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)tag.getCompound("InputTank"));
            tooltip.add((Component)Component.empty().append((Component)Component.translatable((String)"info.woot_revived.cell.amount").append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE)).append(WootContainerScreen.formatInteger(fluid.getAmount())).append((Component)Component.literal((String)"/").setStyle(WootStyles.MACHINE_STYLE)).append(WootContainerScreen.formatInteger(capacity)).append((Component)Component.literal((String)"mB").setStyle(WootStyles.UNIT_STYLE)));
        }
    }

    public static class State
    extends FactoryBlockBase.State {
        public State(Block block, ImmutableMap<Property<?>, Comparable<?>> map, MapCodec<BlockState> codec) {
            super(block, map, codec);
        }

        @NotNull
        public InteractionResult use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            if (!((Boolean)this.getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
                return InteractionResult.PASS;
            }
            if (!(level.getBlockEntity(hit.getBlockPos()) instanceof CellBlockEntity)) {
                throw new IllegalStateException("BlockEntity is missing");
            }
            ItemStack heldItem = player.getItemInHand(hand);
            if (FluidUtil.getFluidHandler((ItemStack)heldItem).isPresent()) {
                return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)level, (BlockPos)hit.getBlockPos(), (Direction)hit.getDirection()) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
            }
            return super.use(level, player, hand, hit);
        }
    }
}

