/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.cell;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.config.CellConfig;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.registries.FluidsRegistry;
import wootrevived.woot.util.block.FactoryBlockBaseEntity;
import wootrevived.woot.util.handlers.WootFluidTankHandler;

public class CellBlockEntity
extends FactoryBlockBaseEntity {
    public final WootFluidTankHandler tankHandler = this.createTank();

    public CellBlockEntity(BlockEntityType<?> entity, BlockPos pos, BlockState state) {
        super(entity, pos, state);
        this.tankHandler.setCapacity(this.getCapacity());
    }

    private WootFluidTankHandler createTank() {
        return new WootFluidTankHandler(1000, false, stack -> stack.isFluidEqual(new FluidStack((Fluid)FluidsRegistry.SOURCE_VITALITY_FUEL_FLUID.get(), 1))){

            protected void onContentsChanged() {
                CellBlockEntity.this.setChanged();
            }
        };
    }

    private int getCapacity() {
        if (this.getType() == BlocksRegistry.COPPER_CELL_BLOCK_ENTITY.get()) {
            return (Integer)CellConfig.COPPER_CAPACITY.get();
        }
        if (this.getType() == BlocksRegistry.IRON_CELL_BLOCK_ENTITY.get()) {
            return (Integer)CellConfig.IRON_CAPACITY.get();
        }
        if (this.getType() == BlocksRegistry.GOLD_CELL_BLOCK_ENTITY.get()) {
            return (Integer)CellConfig.GOLD_CAPACITY.get();
        }
        if (this.getType() == BlocksRegistry.DIAMOND_CELL_BLOCK_ENTITY.get()) {
            return (Integer)CellConfig.DIAMOND_CAPACITY.get();
        }
        if (this.getType() == BlocksRegistry.NETHERITE_CELL_BLOCK_ENTITY.get()) {
            return (Integer)CellConfig.NETHERITE_CAPACITY.get();
        }
        return 0;
    }

    public static IFluidHandler getFluidHandlerCapability(CellBlockEntity blockEntity, Direction side) {
        if (((Boolean)blockEntity.getBlockState().getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
            return blockEntity.tankHandler;
        }
        return null;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag) {
        super.saveAdditional(tag);
        tag.put("InputTank", (Tag)this.tankHandler.writeToNBT(new CompoundTag()));
    }

    @Override
    public void load(@NotNull CompoundTag tag) {
        super.load(tag);
        this.tankHandler.readFromNBT(tag.getCompound("InputTank"));
    }

    @Override
    @NotNull
    public CompoundTag getUpdateTag() {
        CompoundTag tag = super.getUpdateTag();
        this.saveAdditional(tag);
        return tag;
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.load(tag);
    }

    @Override
    public void setChanged() {
        super.setChanged();
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }
}

