/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.creative_power;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.registries.BlocksRegistry;

public class CreativePowerBlockEntity
extends BlockEntity
implements BlockEntityTicker<BlockEntity> {
    private final EnergyStorage energyHandler = this.createEnergy();

    public CreativePowerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlocksRegistry.CREATIVE_POWER_BLOCK_ENTITY.get(), pos, state);
    }

    public static void ticker(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof CreativePowerBlockEntity) {
            CreativePowerBlockEntity creativePowerBlockEntity = (CreativePowerBlockEntity)blockEntity;
            creativePowerBlockEntity.tick(level, pos, state, blockEntity);
        }
    }

    public void tick(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull BlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        for (Direction facing : Direction.values()) {
            IEnergyStorage storage = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, this.getBlockPos().relative(facing), (Object)facing.getOpposite());
            if (storage == null || !storage.canReceive()) continue;
            storage.receiveEnergy(1000, false);
        }
    }

    private EnergyStorage createEnergy() {
        EnergyStorage es = new EnergyStorage(Integer.MAX_VALUE);
        es.receiveEnergy(Integer.MAX_VALUE, false);
        return es;
    }

    public static IEnergyStorage getEnergyStorageCapability(CreativePowerBlockEntity blockEntity, Direction side) {
        return blockEntity.energyHandler;
    }
}

