/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.creative_tank;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.util.handlers.WootFluidTankHandler;

public class CreativeTankBlockEntity
extends BlockEntity
implements BlockEntityTicker<BlockEntity> {
    public WootFluidTankHandler inputTankHandler = this.createInputTank();

    public CreativeTankBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlocksRegistry.CREATIVE_TANK_BLOCK_ENTITY.get(), pos, state);
    }

    private WootFluidTankHandler createInputTank() {
        return new WootFluidTankHandler(Integer.MAX_VALUE, false){

            protected void onContentsChanged() {
                if (!this.getFluid().isEmpty()) {
                    this.getFluid().setAmount(Integer.MAX_VALUE);
                }
                CreativeTankBlockEntity.this.setChanged();
            }
        };
    }

    public static void ticker(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof CreativeTankBlockEntity) {
            CreativeTankBlockEntity creativeTankBlockEntity = (CreativeTankBlockEntity)blockEntity;
            creativeTankBlockEntity.tick(level, pos, state, blockEntity);
        }
    }

    public void tick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull BlockEntity blockEntity) {
        for (Direction facing : Direction.values()) {
            IFluidHandler handler = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, this.getBlockPos().relative(facing), (Object)facing.getOpposite());
            if (handler == null) continue;
            handler.fill(new FluidStack(this.inputTankHandler.getFluid().getFluid(), handler.getTankCapacity(0)), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public void setMaxCapacity() {
        this.inputTankHandler.getFluid().setAmount(Integer.MAX_VALUE);
        this.setChanged();
    }

    public void emptyIfDifferentFluidStack(FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            return;
        }
        if (!this.inputTankHandler.getFluid().isFluidEqual(fluidStack)) {
            this.inputTankHandler.setFluid(FluidStack.EMPTY);
        }
    }

    public static IFluidHandler getFluidHandlerCapability(CreativeTankBlockEntity blockEntity, Direction side) {
        return blockEntity.inputTankHandler;
    }

    protected void saveAdditional(@NotNull CompoundTag tag) {
        super.saveAdditional(tag);
        tag.put("InputTank", (Tag)this.inputTankHandler.writeToNBT(new CompoundTag()));
    }

    public void load(@NotNull CompoundTag tag) {
        super.load(tag);
        this.inputTankHandler.readFromNBT(tag.getCompound("InputTank"));
    }

    @NotNull
    public CompoundTag getUpdateTag() {
        CompoundTag tag = super.getUpdateTag();
        this.saveAdditional(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.load(tag);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void setChanged() {
        super.setChanged();
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }
}

