/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.dye_liquifier;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.blocks.dye_liquifier.DyeLiquifierBlockEntity;
import wootrevived.woot.config.DyeLiquifierConfig;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.util.render.WootContainerScreen;
import wootrevived.woot.util.render.WootStyles;

public class DyeLiquifierBlock
extends Block
implements EntityBlock {
    protected StateDefinition<Block, BlockState> dyeLiquifierStateDefinition;

    public DyeLiquifierBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.METAL).strength(3.5f));
        StateDefinition.Builder stateDefinitionBuilder = new StateDefinition.Builder((Object)this);
        this.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)stateDefinitionBuilder);
        this.dyeLiquifierStateDefinition = stateDefinitionBuilder.create(Block::defaultBlockState, State::new);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    public StateDefinition<Block, BlockState> getStateDefinition() {
        return this.dyeLiquifierStateDefinition;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return ((BlockEntityType)BlocksRegistry.DYE_LIQUIFIER_BLOCK_ENTITY.get()).create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        if (level.isClientSide()) {
            return null;
        }
        return blockEntityType == BlocksRegistry.DYE_LIQUIFIER_BLOCK_ENTITY.get() ? DyeLiquifierBlockEntity::ticker : null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(@NotNull ItemStack stack, @Nullable BlockGetter block, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.appendHoverText(stack, block, tooltip, flag);
        CompoundTag tag = stack.getTagElement("BlockEntityTag");
        if (tag == null) {
            return;
        }
        if (tag.contains("Energy")) {
            CompoundTag energyTag = tag.getCompound("Energy");
            tooltip.add((Component)Component.empty().append((Component)Component.translatable((String)"info.woot_revived.power").append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE)).append((Component)Component.literal((String)WootContainerScreen.formatInteger(energyTag.getInt("Energy")))).append((Component)Component.literal((String)"/").setStyle(WootStyles.MACHINE_STYLE)).append(WootContainerScreen.formatInteger((Integer)DyeLiquifierConfig.ENERGY_CAPACITY.get())).append((Component)Component.literal((String)" FE").setStyle(WootStyles.UNIT_STYLE)));
        }
        if (tag.contains("InternalTanks")) {
            CompoundTag nbtDye = tag.getCompound("InternalTanks");
            this.appendColor(tooltip, nbtDye.getInt("Red"), (Integer)DyeLiquifierConfig.RED_TANK_CAPACITY.get(), Component.translatable((String)"info.woot_revived.dye.red"));
            this.appendColor(tooltip, nbtDye.getInt("Yellow"), (Integer)DyeLiquifierConfig.YELLOW_TANK_CAPACITY.get(), Component.translatable((String)"info.woot_revived.dye.yellow"));
            this.appendColor(tooltip, nbtDye.getInt("Blue"), (Integer)DyeLiquifierConfig.BLUE_TANK_CAPACITY.get(), Component.translatable((String)"info.woot_revived.dye.blue"));
            this.appendColor(tooltip, nbtDye.getInt("White"), (Integer)DyeLiquifierConfig.WHITE_TANK_CAPACITY.get(), Component.translatable((String)"info.woot_revived.dye.white"));
        }
        if (tag.contains("OutputTank")) {
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)tag.getCompound("OutputTank"));
            tooltip.add((Component)Component.empty().append((Component)Component.translatable((String)"info.woot_revived.output_fluid").append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE)).append((Component)(fluid != null && !fluid.isEmpty() ? fluid.getDisplayName() : Component.translatable((String)"info.woot_revived.empty"))));
            tooltip.add((Component)Component.empty().append((Component)Component.translatable((String)"info.woot_revived.output_amount").append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE)).append(WootContainerScreen.formatInteger(fluid.getAmount())).append((Component)Component.literal((String)"/").setStyle(WootStyles.MACHINE_STYLE)).append(WootContainerScreen.formatInteger((Integer)DyeLiquifierConfig.OUTPUT_TANK_CAPACITY.get())).append((Component)Component.literal((String)"mB").setStyle(WootStyles.UNIT_STYLE)));
        }
    }

    private void appendColor(List<Component> tooltip, int amount, int capacity, MutableComponent colorName) {
        tooltip.add((Component)Component.empty().append((Component)colorName.append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE)).append((Component)Component.literal((String)WootContainerScreen.formatInteger(amount))).append((Component)Component.literal((String)"/").setStyle(WootStyles.MACHINE_STYLE)).append(WootContainerScreen.formatInteger(capacity)).append((Component)Component.literal((String)"mB").setStyle(WootStyles.UNIT_STYLE)));
    }

    public static class State
    extends BlockState {
        public State(Block block, ImmutableMap<Property<?>, Comparable<?>> map, MapCodec<BlockState> codec) {
            super(block, map, codec);
        }

        @NotNull
        public InteractionResult use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            BlockEntity blockEntity = level.getBlockEntity(hit.getBlockPos());
            if (!(blockEntity instanceof DyeLiquifierBlockEntity)) {
                throw new IllegalStateException("BlockEntity is missing");
            }
            DyeLiquifierBlockEntity liquifier = (DyeLiquifierBlockEntity)blockEntity;
            ItemStack heldItem = player.getItemInHand(hand);
            if (FluidUtil.getFluidHandler((ItemStack)heldItem).isPresent()) {
                return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)level, (BlockPos)hit.getBlockPos(), (Direction)hit.getDirection()) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
            }
            player.openMenu((MenuProvider)liquifier, buf -> buf.writeBlockPos(hit.getBlockPos()));
            return InteractionResult.SUCCESS;
        }

        public void onRemove(@NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
            if (this.getBlock() != newState.getBlock()) {
                BlockEntity te = level.getBlockEntity(pos);
                if (te instanceof DyeLiquifierBlockEntity) {
                    DyeLiquifierBlockEntity liquifier = (DyeLiquifierBlockEntity)te;
                    liquifier.dropContents(level, pos);
                }
                super.onRemove(level, pos, newState, isMoving);
            }
        }

        public BlockState rotate(LevelAccessor level, BlockPos pos, Rotation rotation) {
            return (BlockState)this.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)rotation.rotate((Direction)this.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
        }

        @NotNull
        public BlockState mirror(Mirror mirror) {
            return this.rotate(null, null, mirror.getRotation((Direction)this.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
        }
    }
}

