/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.enchanted_liquifier;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.client.render.enchanted_liquifier.EnchantedLiquifierContainerMenu;
import wootrevived.woot.config.EnchantedLiquifierConfig;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.registries.FluidsRegistry;
import wootrevived.woot.util.common.MachineSide;
import wootrevived.woot.util.common.MachineSideProperty;
import wootrevived.woot.util.entity.WootMachineBlockEntity;
import wootrevived.woot.util.handlers.WootFluidHandlerWrapper;
import wootrevived.woot.util.handlers.WootItemHandlerWrapper;
import wootrevived.woot.util.handlers.WootItemStackHandler;
import wootrevived.woot.util.helper.EnchantmentHelper;

public class EnchantedLiquifierBlockEntity
extends WootMachineBlockEntity
implements MenuProvider {
    private final List<Map<MachineSide, MachineSideProperty>> directionsProperties = new ArrayList<Map<MachineSide, MachineSideProperty>>(2);
    public static final int OUTPUT_FLUID_PROPERTY = 0;
    public static final int INGREDIENT_PROPERTY = 1;
    public final WootItemStackHandler inventoryHandler = new WootItemStackHandler(false){

        protected void onContentsChanged(int slot) {
            EnchantedLiquifierBlockEntity.this.onContentsChanged(slot);
            EnchantedLiquifierBlockEntity.this.setChanged();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.getItem() == Items.ENCHANTED_BOOK && EnchantmentHelper.isEnchanted(stack);
        }
    };
    public static int INPUT_SLOT = 0;

    public EnchantedLiquifierBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlocksRegistry.ENCHANTED_LIQUIFIER_BLOCK_ENTITY.get(), pos, state);
        for (int i = 0; i < 2; ++i) {
            EnumMap properties = Maps.newEnumMap(MachineSide.class);
            for (MachineSide side : MachineSide.values()) {
                properties.put(side, MachineSideProperty.ENABLED);
            }
            this.directionsProperties.add(properties);
        }
    }

    public static void ticker(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof EnchantedLiquifierBlockEntity) {
            EnchantedLiquifierBlockEntity enchantedLiquifierBlockEntity = (EnchantedLiquifierBlockEntity)blockEntity;
            enchantedLiquifierBlockEntity.tick(level, pos, state, blockEntity);
        }
    }

    @Override
    public void tick(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull BlockEntity blockEntity) {
        super.tick(level, pos, state, blockEntity);
        if (level.isClientSide) {
            return;
        }
        this.tickFluid(this.outputTankHandler, pos, (Integer)EnchantedLiquifierConfig.FLUID_TRANSFER.get(), side -> this.getProperties((Direction)side).getOutputFluidProperty());
    }

    @Override
    public IItemHandler getInventory() {
        return this.inventoryHandler;
    }

    private Properties getProperties(Direction side) {
        Direction facing = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        return new Properties(this, MachineSide.getMachineSide(facing, side));
    }

    public static IItemHandler getItemHandlerCapability(EnchantedLiquifierBlockEntity blockEntity, Direction side) {
        Properties properties = blockEntity.getProperties(side);
        return new WootItemHandlerWrapper().addHandler(blockEntity.inventoryHandler, properties::getIngredientProperty);
    }

    public static IFluidHandler getFluidHandlerCapability(EnchantedLiquifierBlockEntity blockEntity, Direction side) {
        Properties properties = blockEntity.getProperties(side);
        return new WootFluidHandlerWrapper().addHandler(blockEntity.outputTankHandler, properties::getOutputFluidProperty);
    }

    @Override
    public void load(@NotNull CompoundTag tag) {
        super.load(tag);
        if (tag.contains("InputInventory")) {
            this.inventoryHandler.deserializeNBT(tag.getCompound("InputInventory"));
        }
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag tag) {
        super.saveAdditional(tag);
        tag.put("InputInventory", (Tag)this.inventoryHandler.serializeNBT());
    }

    public void dropContents(Level level, BlockPos pos) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack itemStack = this.inventoryHandler.getStackInSlot(INPUT_SLOT);
        if (!itemStack.isEmpty()) {
            drops.add(itemStack);
            this.inventoryHandler.insertItem(INPUT_SLOT, ItemStack.EMPTY, false);
        }
        super.dropContents(drops);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"gui.woot_revived.enchanted_liquifier.name");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        return new EnchantedLiquifierContainerMenu(containerId, this.level, this.getBlockPos(), playerInventory, player);
    }

    @Override
    public Map<MachineSide, MachineSideProperty> getMachineSideProperties(int index) {
        return this.directionsProperties.get(index);
    }

    @Override
    public List<Map<MachineSide, MachineSideProperty>> getAllMachineSidesProperties() {
        return this.directionsProperties;
    }

    @Override
    public void setAllMachineSidesProperties(List<Map<MachineSide, MachineSideProperty>> directionsProperties) {
        for (int i = 0; i < directionsProperties.size(); ++i) {
            this.directionsProperties.set(i, directionsProperties.get(i));
        }
    }

    @Override
    protected boolean hasEnergy() {
        return this.energyHandler.getEnergyStored() > 0;
    }

    @Override
    protected int useEnergy() {
        return this.energyHandler.internalExtractEnergy(this.getEnergyProcessTransfer(), false);
    }

    @Override
    protected void clearRecipe() {
    }

    @Override
    protected int getRecipeEnergy() {
        ItemStack itemStack = this.inventoryHandler.getStackInSlot(INPUT_SLOT);
        if (itemStack.isEmpty()) {
            return 0;
        }
        return this.getEnchantEnergy(itemStack);
    }

    @Override
    protected void processFinished() {
        ItemStack itemStack = this.inventoryHandler.getStackInSlot(INPUT_SLOT);
        if (itemStack.isEmpty()) {
            return;
        }
        this.inventoryHandler.extractItem(INPUT_SLOT, 1, false);
        int amount = this.getEnchantAmount(itemStack);
        this.outputTankHandler.fill(new FluidStack((Fluid)FluidsRegistry.SOURCE_ENCHANTED_FLUID.get(), amount), IFluidHandler.FluidAction.EXECUTE);
        this.setChanged();
    }

    @Override
    protected boolean canProcess(boolean checkEnergy) {
        int filled;
        if (checkEnergy && this.energyHandler.getEnergyStored() <= 0) {
            return false;
        }
        ItemStack itemStack = this.inventoryHandler.getStackInSlot(INPUT_SLOT);
        if (itemStack.isEmpty()) {
            return false;
        }
        if (!EnchantmentHelper.isEnchanted(itemStack)) {
            return false;
        }
        int amount = this.getEnchantAmount(itemStack);
        return amount == (filled = this.outputTankHandler.fill(new FluidStack((Fluid)FluidsRegistry.SOURCE_ENCHANTED_FLUID.get(), amount), IFluidHandler.FluidAction.SIMULATE));
    }

    private int getEnchantAmount(ItemStack itemStack) {
        int amount = 0;
        if (!itemStack.isEmpty() && EnchantmentHelper.isEnchanted(itemStack)) {
            ListTag listNBT = itemStack.getItem() == Items.ENCHANTED_BOOK ? EnchantedBookItem.getEnchantments((ItemStack)itemStack) : itemStack.getEnchantmentTags();
            for (int i = 0; i < listNBT.size(); ++i) {
                CompoundTag compoundNBT = listNBT.getCompound(i);
                Enchantment enchantment = (Enchantment)BuiltInRegistries.ENCHANTMENT.get(ResourceLocation.tryParse((String)compoundNBT.getString("id")));
                if (enchantment == null || !compoundNBT.contains("lvl")) continue;
                amount += Mth.clamp((int)compoundNBT.getInt("lvl"), (int)1, (int)((Integer)EnchantedLiquifierConfig.MAX_ENCHANT_LVL.get())) * (Integer)EnchantedLiquifierConfig.PER_ENCHANT_FLUID.get();
            }
        }
        return amount;
    }

    private int getEnchantEnergy(ItemStack itemStack) {
        int amount = 0;
        if (!itemStack.isEmpty() && EnchantmentHelper.isEnchanted(itemStack)) {
            ListTag listNBT = itemStack.getItem() == Items.ENCHANTED_BOOK ? EnchantedBookItem.getEnchantments((ItemStack)itemStack) : itemStack.getEnchantmentTags();
            for (int i = 0; i < listNBT.size(); ++i) {
                CompoundTag compoundNBT = listNBT.getCompound(i);
                Enchantment enchantment = (Enchantment)BuiltInRegistries.ENCHANTMENT.get(ResourceLocation.tryParse((String)compoundNBT.getString("id")));
                if (enchantment == null || !compoundNBT.contains("lvl")) continue;
                amount += Mth.clamp((int)compoundNBT.getInt("lvl"), (int)1, (int)((Integer)EnchantedLiquifierConfig.MAX_ENCHANT_LVL.get())) * (Integer)EnchantedLiquifierConfig.PER_ENCHANT_ENERGY.get();
            }
        }
        return amount;
    }

    @Override
    public int getEnergyCapacity() {
        return (Integer)EnchantedLiquifierConfig.ENERGY_CAPACITY.get();
    }

    @Override
    public int getEnergyMaxTransfer() {
        return (Integer)EnchantedLiquifierConfig.ENERGY_MAX_TRANSFER.get();
    }

    @Override
    public int getEnergyProcessTransfer() {
        return (Integer)EnchantedLiquifierConfig.ENERGY_PROCESS_TRANSFER.get();
    }

    @Override
    public boolean hasEnergyCapability() {
        return true;
    }

    @Override
    public int getInputTankCapacity() {
        return 0;
    }

    @Override
    public boolean hasInputFluidCapability() {
        return false;
    }

    @Override
    public Predicate<FluidStack> getInputFluidValidator() {
        return null;
    }

    @Override
    public int getOutputTankCapacity() {
        return (Integer)EnchantedLiquifierConfig.OUTPUT_TANK_CAPACITY.get();
    }

    @Override
    public boolean hasOutputFluidCapability() {
        return true;
    }

    public record Properties(EnchantedLiquifierBlockEntity entity, MachineSide machineSide) {
        public MachineSideProperty getIngredientProperty() {
            return this.entity.directionsProperties.get(1).get((Object)this.machineSide);
        }

        public MachineSideProperty getOutputFluidProperty() {
            return this.entity.directionsProperties.get(0).get((Object)this.machineSide);
        }
    }
}

