/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.factory;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.util.block.FactoryBlockBase;

public class FactoryBlock
extends FactoryBlockBase {
    protected StateDefinition<Block, BlockState> factoryStateDefinition;

    public FactoryBlock(Supplier<BlockEntityType<?>> entity) {
        super(entity, BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.STONE).strength(3.5f));
        StateDefinition.Builder stateDefinitionBuilder = new StateDefinition.Builder((Object)this);
        this.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)stateDefinitionBuilder);
        this.factoryStateDefinition = stateDefinitionBuilder.create(Block::defaultBlockState, State::new);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(true)));
    }

    @NotNull
    public StateDefinition<Block, BlockState> getStateDefinition() {
        return this.factoryStateDefinition;
    }

    public static class State
    extends FactoryBlockBase.State {
        public State(Block block, ImmutableMap<Property<?>, Comparable<?>> map, MapCodec<BlockState> codec) {
            super(block, map, codec);
        }
    }
}

