/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.factory;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.util.block.FactoryBlockBase;

public class FactoryBlockItem
extends BlockItem {
    public FactoryBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        Direction face = context.getClickedFace();
        ItemStack heldItem = context.getItemInHand();
        if (player == null) {
            return super.useOn(context);
        }
        if (!player.getAbilities().mayBuild) {
            return super.useOn(context);
        }
        BlockState blockState = level.getBlockState(pos);
        if (this.tryRePlaceBlock(context, level, player, pos, heldItem, blockState)) {
            return InteractionResult.CONSUME;
        }
        switch (face) {
            case EAST: {
                pos = pos.offset(1, 0, 0);
                break;
            }
            case WEST: {
                pos = pos.offset(-1, 0, 0);
                break;
            }
            case UP: {
                pos = pos.offset(0, 1, 0);
                break;
            }
            case DOWN: {
                pos = pos.offset(0, -1, 0);
                break;
            }
            case SOUTH: {
                pos = pos.offset(0, 0, 1);
                break;
            }
            case NORTH: {
                pos = pos.offset(0, 0, -1);
            }
        }
        blockState = level.getBlockState(pos);
        if (this.tryRePlaceBlock(context, level, player, pos, heldItem, blockState)) {
            return InteractionResult.CONSUME;
        }
        return super.useOn(context);
    }

    private boolean tryRePlaceBlock(UseOnContext context, Level level, Player player, BlockPos pos, ItemStack heldItem, BlockState blockState) {
        Block block = blockState.getBlock();
        if (block instanceof FactoryBlockBase) {
            FactoryBlockBase block2 = (FactoryBlockBase)block;
            block = heldItem.getItem();
            if (block instanceof FactoryBlockItem) {
                FactoryBlockItem item = (FactoryBlockItem)block;
                if (block2.verifyItem(heldItem.getItem()) && !((Boolean)blockState.getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
                    BlockState state = item.getBlock().defaultBlockState();
                    if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                        state = (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
                    }
                    level.setBlock(pos, state, 11);
                    this.updateCustomBlockEntityTag(pos, level, player, heldItem, state);
                    level.updateNeighborsAt(pos, state.getBlock());
                    block2.setPlacedBy(level, pos, state, (LivingEntity)player, heldItem);
                    level.playSound(null, pos, state.getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 0.8f);
                    level.gameEvent(GameEvent.BLOCK_PLACE, pos, GameEvent.Context.of((Entity)player, (BlockState)state));
                    player.swing(context.getHand());
                    if (!player.getAbilities().instabuild) {
                        heldItem.shrink(1);
                    }
                    return true;
                }
            }
        }
        return false;
    }
}

