/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.factory_base;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;

public class FactoryBaseBlock
extends Block {
    protected StateDefinition<Block, BlockState> baseStateDefinition;

    public FactoryBaseBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.METAL).strength(3.5f));
        StateDefinition.Builder stateDefinitionBuilder = new StateDefinition.Builder((Object)this);
        this.createBlockStateDefinition(stateDefinitionBuilder);
        this.baseStateDefinition = stateDefinitionBuilder.create(Block::defaultBlockState, State::new);
        this.registerDefaultState((BlockState)this.baseStateDefinition.any());
    }

    @NotNull
    public StateDefinition<Block, BlockState> getStateDefinition() {
        return this.baseStateDefinition;
    }

    public static class State
    extends BlockState {
        public State(Block block, ImmutableMap<Property<?>, Comparable<?>> map, MapCodec<BlockState> codec) {
            super(block, map, codec);
        }
    }
}

