/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.factory_upgrade;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import wootrevived.api.WootUpgradeItem;
import wootrevived.api.interfaces.WootDropsProperties;
import wootrevived.api.interfaces.WootGenerationProperties;
import wootrevived.api.interfaces.WootSpawnProperties;
import wootrevived.woot.client.model.factory_upgrade.FactoryUpgradeBakedModel;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.registries.UpgradeItemsRegistry;
import wootrevived.woot.util.block.FactoryBlockBaseEntity;

public class FactoryUpgradeBlockEntity
extends FactoryBlockBaseEntity {
    private WootUpgradeItem upgradeItem = null;
    private CompoundTag upgradeNBT = new CompoundTag();

    public FactoryUpgradeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlocksRegistry.FACTORY_UPGRADE_BLOCK_ENTITY.get(), pos, state);
    }

    public void applyGenerationProperties(WootGenerationProperties properties) {
        if (this.upgradeItem != null) {
            this.upgradeItem.applyGenerationProperties(properties, this.upgradeNBT);
        }
    }

    public void applySpawnProperties(WootSpawnProperties properties) {
        if (this.upgradeItem != null) {
            this.upgradeItem.applySpawnProperties(properties, this.upgradeNBT);
        }
    }

    public void modifyDrops(WootDropsProperties properties) {
        if (this.upgradeItem != null) {
            this.upgradeItem.modifyDrops(properties, this.upgradeNBT);
        }
    }

    public String getUpgradeItemName() {
        return this.upgradeItem == null ? "" : UpgradeItemsRegistry.getNameFromItem(this.upgradeItem);
    }

    public ItemStack getUpgradeItemStack() {
        return this.upgradeItem == null ? ItemStack.EMPTY : this.upgradeItem.getDefaultInstance();
    }

    public void addUpgrade(Level level, Player player, InteractionHand hand, ItemStack stack, WootUpgradeItem newUpgradeItem) {
        if (this.upgradeItem == newUpgradeItem) {
            return;
        }
        WootUpgradeItem oldUpgradeItem = this.upgradeItem;
        this.upgradeItem = newUpgradeItem;
        this.upgradeNBT = new CompoundTag();
        newUpgradeItem.initUpgradeTag(this.upgradeNBT, (HolderLookup.Provider)level.registryAccess());
        this.setChanged();
        player.swing(hand);
        if (!player.isCreative()) {
            stack.shrink(1);
            if (oldUpgradeItem != null) {
                if (stack.isEmpty()) {
                    player.setItemInHand(hand, oldUpgradeItem.getDefaultInstance());
                } else {
                    this.dropItem(level, player.getOnPos().above(), oldUpgradeItem);
                }
            }
        }
    }

    public void removeUpgrade(Level level, Player player, InteractionHand hand) {
        WootUpgradeItem oldUpgradeItem = this.upgradeItem;
        this.upgradeItem = null;
        this.upgradeNBT = new CompoundTag();
        this.setChanged();
        player.swing(hand);
        if (oldUpgradeItem != null) {
            if (player.getItemInHand(hand).isEmpty()) {
                player.setItemInHand(hand, oldUpgradeItem.getDefaultInstance());
            } else {
                this.dropItem(level, player.getOnPos().above(), oldUpgradeItem);
            }
        }
    }

    public void dropItem(Level level, BlockPos pos) {
        if (this.upgradeItem == null) {
            return;
        }
        this.dropItem(level, pos, this.upgradeItem);
    }

    public void dropItem(Level level, BlockPos pos, WootUpgradeItem upgradeItem) {
        ItemStack stack = upgradeItem.getDefaultInstance();
        Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag) {
        super.saveAdditional(tag);
        tag.put("UpgradeItem", (Tag)StringTag.valueOf((String)this.getUpgradeItemName()));
        tag.put("UpgradeItemNBT", (Tag)this.upgradeNBT);
    }

    @Override
    public void load(@NotNull CompoundTag tag) {
        String item;
        super.load(tag);
        this.upgradeItem = tag.contains("UpgradeItem") ? (!(item = tag.getString("UpgradeItem")).isEmpty() && UpgradeItemsRegistry.has(item) ? (WootUpgradeItem)((Object)UpgradeItemsRegistry.get(item).get()) : null) : null;
        if (tag.contains("UpgradeItemNBT")) {
            this.upgradeNBT = tag.getCompound("UpgradeItemNBT");
        }
    }

    @Override
    @NotNull
    public CompoundTag getUpdateTag() {
        CompoundTag tag = super.getUpdateTag();
        this.saveAdditional(tag);
        return tag;
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.load(tag);
    }

    @Override
    public void setChanged() {
        super.setChanged();
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    @NotNull
    public ModelData getModelData() {
        BlockState state = this.getBlockState();
        BlockRenderDispatcher renderer = Minecraft.getInstance().getBlockRenderer();
        BakedModel model = renderer.getBlockModel(state);
        return model.getModelData((BlockAndTintGetter)this.level, this.getBlockPos(), this.getBlockState(), super.getModelData());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tryRequestModelDataUpdate() {
        if (this.level == null || this.level.getModelDataManager() == null) {
            return;
        }
        ModelData data = this.level.getModelDataManager().getAt(this.getBlockPos());
        if (data != null && data.has(FactoryUpgradeBakedModel.UPGRADE_PROPERTY)) {
            if (this.upgradeItem == null && !((String)data.get(FactoryUpgradeBakedModel.UPGRADE_PROPERTY)).isEmpty()) {
                this.requestModelDataUpdate();
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            } else if (this.upgradeItem != null && !((String)data.get(FactoryUpgradeBakedModel.UPGRADE_PROPERTY)).equalsIgnoreCase(UpgradeItemsRegistry.getNameFromItem(this.upgradeItem))) {
                this.requestModelDataUpdate();
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            }
        }
    }
}

