/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.fake_spawner;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.api.WootFactoryMob;
import wootrevived.api.enums.Tier;
import wootrevived.woot.network.WootFakeSpawnerUpdate;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.registries.WootFactoryMobsRegistry;
import wootrevived.woot.util.block.FactoryBlockBaseEntity;
import wootrevived.woot.util.common.RedstoneMode;
import wootrevived.woot.util.handlers.WootFluidTankHandler;

public class FakeSpawnerBlockEntity
extends FactoryBlockBaseEntity {
    private CompoundTag mobTag = null;
    public int index;
    private int vitalityCost = 0;
    private int totalDrained = 0;
    private double perTickRatio = 0.0;
    private double accumulator = 0.0;
    private int numOfSim = 0;
    protected RedstoneMode redstoneMode = RedstoneMode.ALWAYS_ON;
    private boolean lastRedstoneState = false;

    public FakeSpawnerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlocksRegistry.FAKE_SPAWNER_BLOCK_ENTITY.get(), pos, state);
    }

    @Nullable
    public CompoundTag getMobTag() {
        return this.mobTag;
    }

    @Nullable
    public WootFactoryMob<?> getMob() {
        if (this.mobTag == null) {
            return null;
        }
        return WootFactoryMobsRegistry.getFactoryMob(this.mobTag);
    }

    public int getNumberOfSimulations() {
        return this.numOfSim;
    }

    public int getVitalityCost() {
        return this.vitalityCost;
    }

    public int getTotalDrained() {
        return this.totalDrained;
    }

    public float getETA() {
        return (float)(((double)(this.vitalityCost - this.totalDrained) - this.accumulator) / (this.perTickRatio * 20.0));
    }

    public float getRate() {
        return (float)this.perTickRatio;
    }

    public boolean setActive(int rate, int cost, int numOfSim) {
        if (this.isDisabled()) {
            return false;
        }
        this.perTickRatio = (double)cost / (double)rate;
        this.accumulator = 0.0;
        this.vitalityCost = cost;
        this.totalDrained = 0;
        this.numOfSim = numOfSim;
        this.setChanged();
        return true;
    }

    public boolean isActive() {
        return this.totalDrained < this.vitalityCost;
    }

    public boolean tick(WootFluidTankHandler tank) {
        if (this.getMob() == null || this.getMob().isBlacklisted() || !this.isActive()) {
            return false;
        }
        if (this.redstoneMode != RedstoneMode.ONCE && this.isDisabled()) {
            return false;
        }
        this.accumulator += this.perTickRatio;
        int drainAmount = (int)this.accumulator;
        this.accumulator -= (double)drainAmount;
        if (drainAmount <= 0) {
            return false;
        }
        FluidStack simulate = tank.drain(drainAmount, IFluidHandler.FluidAction.SIMULATE);
        if (simulate.getAmount() < drainAmount) {
            this.accumulator += (double)drainAmount - this.perTickRatio;
            this.setChanged();
            return false;
        }
        FluidStack consumed = tank.drain(drainAmount, IFluidHandler.FluidAction.EXECUTE);
        this.totalDrained += consumed.getAmount();
        if (this.totalDrained >= this.vitalityCost) {
            this.vitalityCost = 0;
            this.totalDrained = 0;
            this.setChanged();
            return true;
        }
        this.setChanged();
        return false;
    }

    public Tier getTier() {
        if (this.mobTag == null) {
            return Tier.INVALID;
        }
        if (!WootFactoryMobsRegistry.hasFactoryMob(this.mobTag)) {
            return Tier.INVALID;
        }
        WootFactoryMob<?> mob = WootFactoryMobsRegistry.getFactoryMob(this.mobTag);
        return mob.getTier();
    }

    public static ItemStack getItemStack(CompoundTag tag) {
        ItemStack itemStack = ((Block)BlocksRegistry.FAKE_SPAWNER_BLOCK.get()).asItem().getDefaultInstance();
        CompoundTag blockTag = itemStack.getOrCreateTagElement("BlockEntityTag");
        blockTag.put("Mob", (Tag)tag);
        return itemStack;
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public void setRedstoneMode(RedstoneMode mode) {
        this.redstoneMode = mode;
    }

    protected boolean isDisabled() {
        if (this.redstoneMode == RedstoneMode.ALWAYS_ON) {
            return false;
        }
        boolean current = this.level.hasNeighborSignal(this.getBlockPos());
        if (this.redstoneMode != RedstoneMode.ONCE) {
            return this.redstoneMode == RedstoneMode.WITH_SIGNAL != current;
        }
        boolean risingEdge = !this.lastRedstoneState && current;
        this.lastRedstoneState = current;
        return !risingEdge;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag) {
        super.saveAdditional(tag);
        tag.putInt("RedstoneMode", this.redstoneMode.ordinal());
        CompoundTag mobTag = this.getMobTag();
        if (mobTag != null) {
            tag.put("Mob", (Tag)mobTag);
        }
        tag.putInt("NumOfSim", this.numOfSim);
        tag.putInt("VitalityCost", this.vitalityCost);
        tag.putInt("TotalDrained", this.totalDrained);
        tag.putDouble("PerTickRatio", this.perTickRatio);
        tag.putDouble("Accumulator", this.accumulator);
    }

    @Override
    public void load(@NotNull CompoundTag tag) {
        super.load(tag);
        this.redstoneMode = RedstoneMode.byIndex(tag.getInt("RedstoneMode"));
        if (tag.contains("Mob")) {
            this.mobTag = tag.getCompound("Mob");
        }
        this.numOfSim = tag.getInt("NumOfSim");
        this.vitalityCost = tag.getInt("VitalityCost");
        this.totalDrained = tag.getInt("TotalDrained");
        this.perTickRatio = tag.getDouble("PerTickRatio");
        this.accumulator = tag.getDouble("Accumulator");
    }

    @Override
    @NotNull
    public CompoundTag getUpdateTag() {
        CompoundTag tag = super.getUpdateTag();
        this.saveAdditional(tag);
        return tag;
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.load(tag);
    }

    @Override
    public void setChanged() {
        super.setChanged();
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public void sendNewState() {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new WootFakeSpawnerUpdate(this.getBlockPos(), this.redstoneMode)});
    }

    public void handleNewState(WootFakeSpawnerUpdate update) {
        if (update.redstoneMode() != null) {
            this.redstoneMode = update.redstoneMode();
        }
        this.setChanged();
    }

    public boolean canPlayerAccess(ServerPlayer player) {
        return !(player.distanceToSqr((double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.5) > 64.0);
    }
}

