/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.fake_spawner;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.api.WootFactoryMob;
import wootrevived.woot.blocks.factory.FactoryBlockItem;
import wootrevived.woot.blocks.fake_spawner.FakeSpawnerBlockEntity;
import wootrevived.woot.registries.WootFactoryMobsRegistry;
import wootrevived.woot.util.common.WootTier;
import wootrevived.woot.util.helper.ModNameHelper;
import wootrevived.woot.util.render.WootStyles;

public class FakeSpawnerBlockItem
extends FactoryBlockItem {
    public FakeSpawnerBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.appendHoverText(stack, level, tooltip, flag);
        CompoundTag tag = stack.getTagElement("BlockEntityTag");
        if (tag != null && tag.contains("Mob")) {
            WootFactoryMob<?> mob;
            CompoundTag mobTag = tag.getCompound("Mob");
            if (level == null) {
                level = Minecraft.getInstance().level;
            }
            if ((mob = WootFactoryMobsRegistry.getFactoryMob(mobTag)) != null) {
                tooltip.add((Component)mob.getDisplayName(mobTag, (HolderLookup.Provider)level.registryAccess()).setStyle(WootStyles.CAPTURED_STYLE));
                String modId = BuiltInRegistries.ENTITY_TYPE.getKey(mob.getEntityType()).getNamespace();
                tooltip.add((Component)ModNameHelper.getModName(modId).setStyle(WootStyles.MOD_NAME_STYLE));
            }
            tooltip.add((Component)Component.translatable((String)"info.woot_revived.tier").append((Component)Component.literal((String)": ")).append((Component)Component.translatable((String)WootTier.getTranslationKey(mob.getTier()))).setStyle(WootStyles.DESCRIPTION_STYLE));
        }
    }

    protected boolean updateCustomBlockEntityTag(@NotNull BlockPos pos, @NotNull Level level, @Nullable Player player, @NotNull ItemStack stack, @NotNull BlockState state) {
        BlockEntity blockEntity;
        super.updateCustomBlockEntityTag(pos, level, player, stack, state);
        if (stack.hasTag() && stack.getTagElement("BlockEntityTag") != null && (blockEntity = level.getBlockEntity(pos)) instanceof FakeSpawnerBlockEntity) {
            FakeSpawnerBlockEntity fakeSpawnerBlockEntity = (FakeSpawnerBlockEntity)blockEntity;
            CompoundTag tag = stack.getTagElement("BlockEntityTag");
            fakeSpawnerBlockEntity.load(tag);
            fakeSpawnerBlockEntity.setChanged();
        }
        return true;
    }
}

