/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.heart;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.blocks.heart.HeartBlockEntity;
import wootrevived.woot.multiblock.MultiBlockFactory;
import wootrevived.woot.util.render.WootShapes;

public class HeartBlock
extends MultiBlockFactory {
    protected StateDefinition<Block, BlockState> heartStateDefinition;

    public HeartBlock(Supplier<BlockEntityType<?>> entity) {
        super(entity, BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.METAL).strength(3.5f));
        StateDefinition.Builder stateDefinitionBuilder = new StateDefinition.Builder((Object)this);
        this.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)stateDefinitionBuilder);
        this.heartStateDefinition = stateDefinitionBuilder.create(Block::defaultBlockState, State::new);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        return HeartBlockEntity::ticker;
    }

    @NotNull
    public StateDefinition<Block, BlockState> getStateDefinition() {
        return this.heartStateDefinition;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
        builder.add(new Property[]{BlockStateProperties.ENABLED});
    }

    public static class State
    extends MultiBlockFactory.State {
        public State(Block block, ImmutableMap<Property<?>, Comparable<?>> map, MapCodec<BlockState> codec) {
            super(block, map, codec);
        }

        @NotNull
        public InteractionResult use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            if (!((Boolean)this.getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
                return InteractionResult.PASS;
            }
            BlockEntity blockEntity = level.getBlockEntity(hit.getBlockPos());
            if (!(blockEntity instanceof HeartBlockEntity)) {
                throw new IllegalStateException("BlockEntity is missing");
            }
            HeartBlockEntity heart = (HeartBlockEntity)blockEntity;
            player.openMenu((MenuProvider)heart, buf -> buf.writeBlockPos(hit.getBlockPos()));
            return InteractionResult.SUCCESS;
        }

        public BlockState rotate(LevelAccessor level, BlockPos pos, Rotation rotation) {
            return (BlockState)this.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)rotation.rotate((Direction)this.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
        }

        @NotNull
        public BlockState mirror(Mirror mirror) {
            return this.rotate(null, null, mirror.getRotation((Direction)this.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
        }

        @Override
        @NotNull
        public VoxelShape getShape(@NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
            if (!((Boolean)this.getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
                return WootShapes.disabledShape;
            }
            return Shapes.block();
        }

        @Override
        @NotNull
        public RenderShape getRenderShape() {
            if (((Boolean)this.getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
                return RenderShape.MODEL;
            }
            return RenderShape.ENTITYBLOCK_ANIMATED;
        }

        @Override
        public void onPlace(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
            if (((Boolean)this.getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
                super.onPlace(level, pos, newState, isMoving);
            }
        }

        @Override
        public void onRemove(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
            if (((Boolean)this.getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
                super.onRemove(level, pos, newState, isMoving);
            }
        }
    }
}

