/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.ingredient_import;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.util.block.FactoryBlockBaseEntity;
import wootrevived.woot.util.handlers.WootImportFluidHandler;
import wootrevived.woot.util.handlers.WootImportItemHandler;

public class IngredientImportBlockEntity
extends FactoryBlockBaseEntity {
    private final WootImportItemHandler itemHandler = new WootImportItemHandler();
    private final WootImportFluidHandler fluidHandler = new WootImportFluidHandler();

    public IngredientImportBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlocksRegistry.IMPORT_BLOCK_ENTITY.get(), pos, state);
    }

    public void setImportItem(int index, List<ItemStack> importItem) {
        this.itemHandler.setImportItem(index, importItem);
    }

    public void setImportFluid(int index, List<FluidStack> importFluid) {
        this.fluidHandler.setImportFluid(index, importFluid);
    }

    public boolean isImportValid(int index) {
        return this.itemHandler.isImportValid(index) && this.fluidHandler.isImportValid(index);
    }

    public void consumeImports(int index) {
        this.itemHandler.consume(index);
        this.fluidHandler.consume(index);
    }

    public void extractNeighbors() {
        for (Direction direction : Direction.values()) {
            IFluidHandler neighborFluidHandler;
            if (direction == Direction.UP || direction == Direction.DOWN) continue;
            BlockPos blockPos = this.getBlockPos().relative(direction);
            IItemHandler neighborItemHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, blockPos, (Object)direction.getOpposite());
            if (neighborItemHandler != null) {
                for (int i = 0; i < neighborItemHandler.getSlots(); ++i) {
                    ItemStack extracted;
                    ItemStack stack = neighborItemHandler.getStackInSlot(i);
                    ItemStack result = this.itemHandler.insertItem(i, stack, true);
                    if (result.getCount() >= stack.getCount() || (extracted = neighborItemHandler.extractItem(i, stack.getCount() - result.getCount(), false)).isEmpty()) continue;
                    this.itemHandler.insertItem(i, extracted, false);
                }
            }
            if ((neighborFluidHandler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, blockPos, (Object)direction.getOpposite())) == null) continue;
            for (int i = 0; i < neighborFluidHandler.getTanks(); ++i) {
                FluidStack drained;
                FluidStack stack = neighborFluidHandler.getFluidInTank(i);
                int filled = this.fluidHandler.fill(stack, IFluidHandler.FluidAction.SIMULATE);
                if (filled <= 0 || (drained = neighborFluidHandler.drain(new FluidStack(stack.getFluid(), filled), IFluidHandler.FluidAction.EXECUTE)).isEmpty()) continue;
                this.fluidHandler.fill(drained, IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    public static IItemHandler getItemHandlerCapability(IngredientImportBlockEntity blockEntity, Direction side) {
        return blockEntity.itemHandler;
    }

    public static IFluidHandler getFluidHandlerCapability(IngredientImportBlockEntity blockEntity, Direction side) {
        return blockEntity.fluidHandler;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag) {
        super.saveAdditional(tag);
        this.itemHandler.save(tag);
        this.fluidHandler.save(tag);
    }

    @Override
    public void load(@NotNull CompoundTag tag) {
        super.load(tag);
        this.itemHandler.load(tag);
        this.fluidHandler.load(tag);
    }

    @Override
    @NotNull
    public CompoundTag getUpdateTag() {
        CompoundTag tag = super.getUpdateTag();
        this.saveAdditional(tag);
        return tag;
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.load(tag);
    }

    @Override
    public void setChanged() {
        super.setChanged();
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }
}

