/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.item_infuser;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.client.render.item_infuser.ItemInfuserContainerMenu;
import wootrevived.woot.config.ItemInfuserConfig;
import wootrevived.woot.recipes.item_infuser.ItemInfuserRecipe;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.registries.RecipesRegistry;
import wootrevived.woot.util.common.MachineSide;
import wootrevived.woot.util.common.MachineSideProperty;
import wootrevived.woot.util.entity.WootMachineBlockEntity;
import wootrevived.woot.util.handlers.WootFluidHandlerWrapper;
import wootrevived.woot.util.handlers.WootItemHandlerWrapper;
import wootrevived.woot.util.handlers.WootItemStackHandler;
import wootrevived.woot.util.recipes.WootContainer;

public class ItemInfuserBlockEntity
extends WootMachineBlockEntity
implements MenuProvider {
    private final List<Map<MachineSide, MachineSideProperty>> directionsProperties = new ArrayList<Map<MachineSide, MachineSideProperty>>(4);
    public static final int INPUT_FLUID_PROPERTY = 0;
    public static final int INGREDIENT_PROPERTY = 1;
    public static final int AUGMENT_PROPERTY = 2;
    public static final int OUTPUT_PROPERTY = 3;
    public static final int INPUT_SLOT = 0;
    public static final int AUGMENT_SLOT = 0;
    public static final int OUTPUT_SLOT = 0;
    private final WootItemStackHandler inputSlotHandler = new WootItemStackHandler(false){

        protected void onContentsChanged(int slot) {
            ItemInfuserBlockEntity.this.onContentsChanged(slot);
            ItemInfuserBlockEntity.this.setChanged();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return ItemInfuserRecipe.Validator.isIngredientValid(stack);
        }
    };
    private final WootItemStackHandler augmentSlotHandler = new WootItemStackHandler(false){

        protected void onContentsChanged(int slot) {
            ItemInfuserBlockEntity.this.onContentsChanged(slot);
            ItemInfuserBlockEntity.this.setChanged();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return ItemInfuserRecipe.Validator.isAugmentValid(stack);
        }
    };
    private final WootItemStackHandler outputSlotHandler = new WootItemStackHandler(true){

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return stack;
        }
    };
    private final IItemHandler allSlotsHandler = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputSlotHandler, this.augmentSlotHandler, this.outputSlotHandler});
    private ItemInfuserRecipe recipe = null;

    public ItemInfuserBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlocksRegistry.ITEM_INFUSER_BLOCK_ENTITY.get(), pos, state);
        for (int i = 0; i < 4; ++i) {
            EnumMap properties = Maps.newEnumMap(MachineSide.class);
            for (MachineSide side : MachineSide.values()) {
                properties.put(side, MachineSideProperty.ENABLED);
            }
            this.directionsProperties.add(properties);
        }
    }

    public static void ticker(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof ItemInfuserBlockEntity) {
            ItemInfuserBlockEntity itemInfuserBlockEntity = (ItemInfuserBlockEntity)blockEntity;
            itemInfuserBlockEntity.tick(level, pos, state, blockEntity);
        }
    }

    @Override
    public void tick(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull BlockEntity blockEntity) {
        super.tick(level, pos, state, blockEntity);
        if (level.isClientSide) {
            return;
        }
        this.tickFluid(this.inputTankHandler, pos, (Integer)ItemInfuserConfig.FLUID_TRANSFER.get(), side -> this.getProperties((Direction)side).getInputFluidProperty());
    }

    @Override
    public IItemHandler getInventory() {
        return this.allSlotsHandler;
    }

    private Properties getProperties(Direction side) {
        Direction facing = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        return new Properties(this, MachineSide.getMachineSide(facing, side));
    }

    public static IItemHandler getItemHandlerCapability(ItemInfuserBlockEntity blockEntity, Direction side) {
        Properties properties = blockEntity.getProperties(side);
        return new WootItemHandlerWrapper().addHandler(blockEntity.outputSlotHandler, properties::getOutputProperty).addHandler(blockEntity.augmentSlotHandler, properties::getAugmentProperty).addHandler(blockEntity.inputSlotHandler, properties::getIngredientProperty);
    }

    public static IFluidHandler getFluidHandlerCapability(ItemInfuserBlockEntity blockEntity, Direction side) {
        Properties properties = blockEntity.getProperties(side);
        return new WootFluidHandlerWrapper().addHandler(blockEntity.inputTankHandler, properties::getInputFluidProperty);
    }

    @Override
    public void load(@NotNull CompoundTag tag) {
        super.load(tag);
        if (tag.contains("InputInventory")) {
            this.inputSlotHandler.deserializeNBT(tag.getCompound("InputInventory"));
        }
        if (tag.contains("AugmentInventory")) {
            this.augmentSlotHandler.deserializeNBT(tag.getCompound("AugmentInventory"));
        }
        if (tag.contains("OutputInventory")) {
            this.outputSlotHandler.deserializeNBT(tag.getCompound("OutputInventory"));
        }
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag tag) {
        super.saveAdditional(tag);
        tag.put("InputInventory", (Tag)this.inputSlotHandler.serializeNBT());
        tag.put("AugmentInventory", (Tag)this.augmentSlotHandler.serializeNBT());
        tag.put("OutputInventory", (Tag)this.outputSlotHandler.serializeNBT());
    }

    public void dropContents(Level level, BlockPos pos) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack itemStack = this.inputSlotHandler.getStackInSlot(0);
        if (!itemStack.isEmpty()) {
            drops.add(itemStack);
            this.inputSlotHandler.setStackInSlot(0, ItemStack.EMPTY);
        }
        if (!(itemStack = this.augmentSlotHandler.getStackInSlot(0)).isEmpty()) {
            drops.add(itemStack);
            this.augmentSlotHandler.setStackInSlot(0, ItemStack.EMPTY);
        }
        if (!(itemStack = this.outputSlotHandler.getStackInSlot(0)).isEmpty()) {
            drops.add(itemStack);
            this.outputSlotHandler.setStackInSlot(0, ItemStack.EMPTY);
        }
        super.dropContents(drops);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"gui.woot_revived.item_infuser.name");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        return new ItemInfuserContainerMenu(containerId, this.level, this.getBlockPos(), playerInventory, player);
    }

    @Override
    public Map<MachineSide, MachineSideProperty> getMachineSideProperties(int index) {
        return this.directionsProperties.get(index);
    }

    @Override
    public List<Map<MachineSide, MachineSideProperty>> getAllMachineSidesProperties() {
        return this.directionsProperties;
    }

    @Override
    public void setAllMachineSidesProperties(List<Map<MachineSide, MachineSideProperty>> directionsProperties) {
        for (int i = 0; i < directionsProperties.size(); ++i) {
            this.directionsProperties.set(i, directionsProperties.get(i));
        }
    }

    @Override
    protected boolean hasEnergy() {
        return this.energyHandler.getEnergyStored() > 0;
    }

    @Override
    protected int useEnergy() {
        return this.energyHandler.internalExtractEnergy(this.getEnergyProcessTransfer(), false);
    }

    @Override
    protected void clearRecipe() {
        this.recipe = null;
    }

    @Override
    protected int getRecipeEnergy() {
        return this.recipe != null ? this.recipe.getEnergy() : 0;
    }

    @Override
    protected void processFinished() {
        if (this.recipe == null) {
            this.getRecipe();
        }
        if (this.recipe == null) {
            this.processOff();
            return;
        }
        ItemInfuserRecipe recipe = this.recipe;
        ItemStack item = this.inputSlotHandler.getStackInSlot(0);
        if (item.getItem().hasCraftingRemainingItem(item)) {
            this.inputSlotHandler.setStackInSlot(0, item.getItem().getCraftingRemainingItem(item));
        } else {
            int inputSize = recipe.ingredientCount(this.inputSlotHandler.getStackInSlot(0).getItem());
            this.inputSlotHandler.extractItem(0, inputSize, false);
        }
        if (recipe.getAugment().isPresent()) {
            ItemStack augment = this.augmentSlotHandler.getStackInSlot(0);
            if (augment.getItem().hasCraftingRemainingItem(augment)) {
                this.augmentSlotHandler.setStackInSlot(0, augment.getItem().getCraftingRemainingItem(augment));
            } else {
                int augmentSize = recipe.augmentCount(this.augmentSlotHandler.getStackInSlot(0).getItem());
                this.augmentSlotHandler.extractItem(0, augmentSize, false);
            }
        }
        ItemStack itemStack = recipe.getOutput();
        ItemStack output = this.outputSlotHandler.getStackInSlot(0);
        if (!output.isEmpty()) {
            output.grow(itemStack.getCount());
        } else {
            this.outputSlotHandler.setStackInSlot(0, itemStack);
        }
        this.inputTankHandler.drain(recipe.getFluid().getAmount(), IFluidHandler.FluidAction.EXECUTE);
        this.setChanged();
    }

    @Override
    protected boolean canProcess(boolean checkEnergy) {
        if (checkEnergy && this.energyHandler.getEnergyStored() <= 0) {
            return false;
        }
        this.getRecipe();
        if (this.recipe == null) {
            return false;
        }
        ItemStack output = this.outputSlotHandler.getStackInSlot(0);
        if (!output.isEmpty() && output.getItem() != this.recipe.getOutput().getItem()) {
            return false;
        }
        return this.inputTankHandler.getFluid().getAmount() >= this.recipe.getFluid().getAmount();
    }

    private void getRecipe() {
        if (this.inputTankHandler.isEmpty() || this.inputTankHandler.getFluid().getFluid().getBucket() == null) {
            this.clearRecipe();
            return;
        }
        RecipeHolder recipeHolder = this.level.getRecipeManager().getRecipeFor((RecipeType)RecipesRegistry.ITEM_INFUSER_RECIPE_TYPE.get(), (Container)new WootContainer(Either.right((Object)this.inputTankHandler.getFluid()), Either.left((Object)this.inputSlotHandler.getStackInSlot(0)), Either.left((Object)this.augmentSlotHandler.getStackInSlot(0))), this.level).orElse(null);
        this.recipe = recipeHolder == null ? null : (ItemInfuserRecipe)recipeHolder.value();
    }

    @Override
    public int getEnergyCapacity() {
        return (Integer)ItemInfuserConfig.ENERGY_CAPACITY.get();
    }

    @Override
    public int getEnergyMaxTransfer() {
        return (Integer)ItemInfuserConfig.ENERGY_MAX_TRANSFER.get();
    }

    @Override
    public int getEnergyProcessTransfer() {
        return (Integer)ItemInfuserConfig.ENERGY_PROCESS_TRANSFER.get();
    }

    @Override
    public boolean hasEnergyCapability() {
        return true;
    }

    @Override
    public int getInputTankCapacity() {
        return (Integer)ItemInfuserConfig.INPUT_TANK_CAPACITY.get();
    }

    @Override
    public boolean hasInputFluidCapability() {
        return true;
    }

    @Override
    public Predicate<FluidStack> getInputFluidValidator() {
        return ItemInfuserRecipe.Validator::isFluidValid;
    }

    @Override
    public int getOutputTankCapacity() {
        return 0;
    }

    @Override
    public boolean hasOutputFluidCapability() {
        return false;
    }

    public record Properties(ItemInfuserBlockEntity entity, MachineSide machineSide) {
        public MachineSideProperty getInputFluidProperty() {
            return this.entity.directionsProperties.get(0).get((Object)this.machineSide);
        }

        public MachineSideProperty getIngredientProperty() {
            return this.entity.directionsProperties.get(1).get((Object)this.machineSide);
        }

        public MachineSideProperty getAugmentProperty() {
            return this.entity.directionsProperties.get(2).get((Object)this.machineSide);
        }

        public MachineSideProperty getOutputProperty() {
            return this.entity.directionsProperties.get(3).get((Object)this.machineSide);
        }
    }
}

