/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.layout;

import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.api.enums.Tier;
import wootrevived.woot.multiblock.patterns.Pattern;
import wootrevived.woot.multiblock.patterns.Patterns;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.util.block.FactoryBlockBase;
import wootrevived.woot.util.common.WootTier;

public class LayoutBlockEntity
extends BlockEntity
implements BlockEntityTicker<BlockEntity> {
    private int blockRenderOffset = 0;
    private static final int TICK_DELAY = 20;
    private int delayTick = 20;
    private Tier tier = Tier.TIER_1;
    static final String KEY_TIER = "tier";

    public LayoutBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlocksRegistry.LAYOUT_BLOCK_ENTITY.get(), pos, state);
    }

    public static void ticker(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof LayoutBlockEntity) {
            LayoutBlockEntity layoutBlockEntity = (LayoutBlockEntity)blockEntity;
            layoutBlockEntity.tick(level, pos, state, blockEntity);
        }
    }

    public int getBlockRenderOffset() {
        return this.blockRenderOffset;
    }

    public void tick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull BlockEntity blockEntity) {
        Direction facing = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        int height = Patterns.getHeight();
        BlockPos layoutPos = switch (facing) {
            case Direction.NORTH -> this.getBlockPos().offset(0, height, -1);
            case Direction.SOUTH -> this.getBlockPos().offset(0, height, 1);
            case Direction.EAST -> this.getBlockPos().offset(1, height, 0);
            case Direction.WEST -> this.getBlockPos().offset(-1, height, 0);
            default -> this.getBlockPos();
        };
        for (Pattern.PatternBlock patternBlock : Patterns.TIER_1.patterns.get(facing)) {
            if (Tier.TIER_1.isFactoryTierValid(this.tier)) {
                LayoutBlockEntity.placePatternBlock(level, facing, layoutPos, patternBlock, this.getBlockRenderOffset());
                continue;
            }
            LayoutBlockEntity.removePatternBlock(level, layoutPos, patternBlock);
        }
        for (Pattern.PatternBlock patternBlock : Patterns.TIER_2.patterns.get(facing)) {
            if (Tier.TIER_2.isFactoryTierValid(this.tier)) {
                LayoutBlockEntity.placePatternBlock(level, facing, layoutPos, patternBlock, this.getBlockRenderOffset());
                continue;
            }
            LayoutBlockEntity.removePatternBlock(level, layoutPos, patternBlock);
        }
        for (Pattern.PatternBlock patternBlock : Patterns.TIER_3.patterns.get(facing)) {
            if (Tier.TIER_3.isFactoryTierValid(this.tier)) {
                LayoutBlockEntity.placePatternBlock(level, facing, layoutPos, patternBlock, this.getBlockRenderOffset());
                continue;
            }
            LayoutBlockEntity.removePatternBlock(level, layoutPos, patternBlock);
        }
        for (Pattern.PatternBlock patternBlock : Patterns.TIER_4.patterns.get(facing)) {
            if (Tier.TIER_4.isFactoryTierValid(this.tier)) {
                LayoutBlockEntity.placePatternBlock(level, facing, layoutPos, patternBlock, this.getBlockRenderOffset());
                continue;
            }
            LayoutBlockEntity.removePatternBlock(level, layoutPos, patternBlock);
        }
        for (Pattern.PatternBlock patternBlock : Patterns.TIER_5.patterns.get(facing)) {
            if (Tier.TIER_5.isFactoryTierValid(this.tier)) {
                LayoutBlockEntity.placePatternBlock(level, facing, layoutPos, patternBlock, this.getBlockRenderOffset());
                continue;
            }
            LayoutBlockEntity.removePatternBlock(level, layoutPos, patternBlock);
        }
        if (this.delayTick-- != 0) {
            return;
        }
        this.delayTick = 20;
        ++this.blockRenderOffset;
    }

    public static void placePatternBlock(@NotNull Level level, Direction facing, BlockPos layoutPos, Pattern.PatternBlock patternBlock, int blockRenderOffset) {
        BlockPos blockPos;
        BlockState state;
        Block block = patternBlock.blocks[blockRenderOffset % (int)Arrays.stream(patternBlock.blocks).count()];
        BlockState blockState = (BlockState)block.getStateDefinition().any();
        if (blockState.hasProperty((Property)BlockStateProperties.ENABLED)) {
            blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(false));
        }
        if (blockState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing);
        }
        if ((state = level.getBlockState(blockPos = patternBlock.getLevelBlockPos(layoutPos))).getBlock() == Blocks.AIR) {
            level.setBlock(blockPos, blockState, 3);
        } else if (state.getBlock() instanceof FactoryBlockBase && state.getBlock() != block && !((Boolean)state.getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
            level.setBlock(blockPos, blockState, 3);
        }
    }

    public static void removePatternBlock(@NotNull Level level, BlockPos layoutPos, Pattern.PatternBlock patternBlock) {
        for (Block block : patternBlock.blocks) {
            BlockPos blockPos = patternBlock.getLevelBlockPos(layoutPos);
            BlockState s = level.getBlockState(blockPos);
            if (!(s.getBlock() instanceof FactoryBlockBase) || s.getBlock() != block || ((Boolean)s.getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) continue;
            level.removeBlock(blockPos, false);
        }
    }

    public Tier getTier() {
        return this.tier;
    }

    public void setNextTier() {
        this.tier = WootTier.getNextValid(this.tier);
        this.setChanged();
    }

    protected void saveAdditional(@NotNull CompoundTag tag) {
        super.saveAdditional(tag);
        tag.putInt(KEY_TIER, this.tier.ordinal());
    }

    public void load(@NotNull CompoundTag tag) {
        super.load(tag);
        if (tag.contains(KEY_TIER)) {
            this.tier = WootTier.byIndex(tag.getInt(KEY_TIER));
        }
    }

    @NotNull
    public CompoundTag getUpdateTag() {
        CompoundTag tag = super.getUpdateTag();
        this.saveAdditional(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.load(tag);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void setChanged() {
        super.setChanged();
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }
}

