/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.stygian_anvil;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.blocks.stygian_anvil.StygianAnvilBlockEntity;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.registries.ItemsRegistry;

public class StygianAnvilBlock
extends Block
implements EntityBlock {
    private static final VoxelShape PART_BASE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    private static final VoxelShape PART_LOWER_X = Block.box((double)3.0, (double)4.0, (double)4.0, (double)13.0, (double)5.0, (double)12.0);
    private static final VoxelShape PART_MID_X = Block.box((double)4.0, (double)5.0, (double)6.0, (double)12.0, (double)10.0, (double)10.0);
    private static final VoxelShape PART_UPPER_X = Block.box((double)0.0, (double)10.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0);
    private static final VoxelShape PART_LOWER_Z = Block.box((double)4.0, (double)4.0, (double)3.0, (double)12.0, (double)5.0, (double)13.0);
    private static final VoxelShape PART_MID_Z = Block.box((double)6.0, (double)5.0, (double)4.0, (double)10.0, (double)10.0, (double)12.0);
    private static final VoxelShape PART_UPPER_Z = Block.box((double)3.0, (double)10.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0);
    private static final VoxelShape X_AXIS_AABB = Shapes.or((VoxelShape)PART_BASE, (VoxelShape[])new VoxelShape[]{PART_LOWER_X, PART_MID_X, PART_UPPER_X});
    private static final VoxelShape Z_AXIS_AABB = Shapes.or((VoxelShape)PART_BASE, (VoxelShape[])new VoxelShape[]{PART_LOWER_Z, PART_MID_Z, PART_UPPER_Z});
    protected StateDefinition<Block, BlockState> anvilStateDefinition;

    public StygianAnvilBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.METAL).strength(3.5f));
        StateDefinition.Builder stateDefinitionBuilder = new StateDefinition.Builder((Object)this);
        this.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)stateDefinitionBuilder);
        this.anvilStateDefinition = stateDefinitionBuilder.create(Block::defaultBlockState, State::new);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    public StateDefinition<Block, BlockState> getStateDefinition() {
        return this.anvilStateDefinition;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getClockWise());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    public boolean isAnvilHot(Level level, BlockPos pos) {
        return level.getBlockState(pos.below()).getBlock() == Blocks.MAGMA_BLOCK;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        super.animateTick(state, level, pos, random);
        if (Minecraft.getInstance().options.particles().get() != ParticleStatus.MINIMAL && random.nextInt(10) == 0 && this.isAnvilHot(level, pos)) {
            level.addParticle((ParticleOptions)ParticleTypes.LAVA, (double)((float)pos.getX() + random.nextFloat()), (double)((float)pos.getY() + 1.1f), (double)((float)pos.getZ() + random.nextFloat()), 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return ((BlockEntityType)BlocksRegistry.STYGIAN_ANVIL_BLOCK_ENTITY.get()).create(pos, state);
    }

    public static class State
    extends BlockState {
        public State(Block block, ImmutableMap<Property<?>, Comparable<?>> map, MapCodec<BlockState> codec) {
            super(block, map, codec);
        }

        @NotNull
        public InteractionResult use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
            BlockEntity be;
            if (level.isClientSide) {
                super.use(level, player, hand, hit);
            }
            if ((be = level.getBlockEntity(hit.getBlockPos())) instanceof StygianAnvilBlockEntity) {
                StygianAnvilBlockEntity anvil = (StygianAnvilBlockEntity)be;
                ItemStack heldItem = player.getItemInHand(hand);
                if (player.isShiftKeyDown() && heldItem.isEmpty()) {
                    anvil.dropItem(player, hand);
                } else if (heldItem.getItem() == ItemsRegistry.STYGIAN_HAMMER_ITEM.get()) {
                    anvil.tryCraft(player);
                } else {
                    IItemHandler itemHandler = anvil.getInventory();
                    for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                        if (!itemHandler.getStackInSlot(slot).isEmpty()) continue;
                        ItemStack item = heldItem.copy();
                        item.setCount(1);
                        ItemStack result = itemHandler.insertItem(slot, item, false);
                        if (result.equals(item)) break;
                        heldItem.shrink(1);
                        if (heldItem.isEmpty()) {
                            player.getInventory().setItem(player.getInventory().selected, ItemStack.EMPTY);
                        } else {
                            player.getInventory().setItem(player.getInventory().selected, heldItem);
                        }
                        player.containerMenu.broadcastChanges();
                        break;
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }

        @NotNull
        public VoxelShape getShape(@NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
            Direction direction = (Direction)this.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            return direction.getAxis() == Direction.Axis.X ? X_AXIS_AABB : Z_AXIS_AABB;
        }

        public void onRemove(@NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
            if (this.getBlock() != newState.getBlock()) {
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof StygianAnvilBlockEntity) {
                    StygianAnvilBlockEntity stygianAnvilBlockEntity = (StygianAnvilBlockEntity)blockEntity;
                    stygianAnvilBlockEntity.dropContents(level, pos);
                }
                super.onRemove(level, pos, newState, isMoving);
            }
        }

        public BlockState rotate(LevelAccessor level, BlockPos pos, Rotation rotation) {
            return (BlockState)this.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)rotation.rotate((Direction)this.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
        }

        @NotNull
        public BlockState mirror(Mirror mirror) {
            return this.rotate(null, null, mirror.getRotation((Direction)this.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
        }
    }
}

