/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.client.model.factory_upgrade;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.BakedModelWrapper;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.api.WootUpgradeItem;
import wootrevived.woot.blocks.factory_upgrade.FactoryUpgradeBlockEntity;
import wootrevived.woot.registries.UpgradeItemsRegistry;

@OnlyIn(value=Dist.CLIENT)
public class FactoryUpgradeBakedModel
extends BakedModelWrapper<SimpleBakedModel> {
    protected final Map<String, Map<Direction, List<BakedQuad>>> faces;
    protected final Map<String, TextureAtlasSprite> particles;
    public static final ModelProperty<String> UPGRADE_PROPERTY = new ModelProperty();

    public FactoryUpgradeBakedModel(Map<String, Map<Direction, List<BakedQuad>>> faces, boolean hasAmbientOcclusion, boolean isGui3d, boolean usesBlockLight, Map<String, TextureAtlasSprite> particles, ItemTransforms transforms, ItemOverrides overrides) {
        super((BakedModel)new SimpleBakedModel(new ArrayList(), faces.get(""), hasAmbientOcclusion, isGui3d, usesBlockLight, particles.get(""), transforms, overrides, RenderTypeGroup.EMPTY));
        this.faces = faces;
        this.particles = particles;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState blockState, @Nullable Direction direction, @NotNull RandomSource randomSource) {
        return this.getQuads(blockState, direction, randomSource, ModelData.EMPTY, null);
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState blockState, @Nullable Direction direction, @NotNull RandomSource randomSource, @NotNull ModelData modelData, @Nullable RenderType renderType) {
        if (direction == null) {
            return ((SimpleBakedModel)this.originalModel).getQuads(blockState, null, randomSource);
        }
        String upgrade = "";
        if (modelData.has(UPGRADE_PROPERTY)) {
            upgrade = (String)modelData.get(UPGRADE_PROPERTY);
        }
        return this.faces.get(upgrade).get(direction);
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        if (data.has(UPGRADE_PROPERTY)) {
            return this.particles.get(data.get(UPGRADE_PROPERTY));
        }
        return this.getParticleIcon();
    }

    @NotNull
    public ModelData getModelData(@Nullable BlockAndTintGetter level, @NotNull BlockPos blockPos, @NotNull BlockState blockState, @NotNull ModelData modelData) {
        BlockEntity entity;
        String upgrade = "";
        if (level instanceof BlockAndTintGetter && (entity = level.getBlockEntity(blockPos)) instanceof FactoryUpgradeBlockEntity) {
            FactoryUpgradeBlockEntity factoryUpgradeBlockEntity = (FactoryUpgradeBlockEntity)entity;
            upgrade = factoryUpgradeBlockEntity.getUpgradeItemName();
        }
        return modelData.derive().with(UPGRADE_PROPERTY, (Object)upgrade).build();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder {
        private final Map<String, Map<Direction, List<BakedQuad>>> faces = new HashMap<String, Map<Direction, List<BakedQuad>>>();
        private final Map<String, TextureAtlasSprite> particles = new HashMap<String, TextureAtlasSprite>();
        private final boolean hasAmbientOcclusion;
        private final boolean usesBlockLight;
        private final boolean isGui3d;
        private final ItemTransforms transforms;
        private final ItemOverrides overrides;

        public Builder(boolean hasAmbientOcclusion, boolean usesBlockLight, boolean isGui3d, ItemTransforms transforms, ItemOverrides overrides) {
            EnumMap map = Maps.newEnumMap(Direction.class);
            for (Direction direction : Direction.values()) {
                map.put(direction, new ArrayList());
            }
            this.faces.put("", map);
            for (DeferredHolder deferredHolder : UpgradeItemsRegistry.getValues()) {
                map = Maps.newEnumMap(Direction.class);
                for (Direction direction : Direction.values()) {
                    map.put(direction, new ArrayList());
                }
                this.faces.put(UpgradeItemsRegistry.getNameFromItem((DeferredHolder<Item, ? extends WootUpgradeItem>)deferredHolder), map);
            }
            this.hasAmbientOcclusion = hasAmbientOcclusion;
            this.usesBlockLight = usesBlockLight;
            this.isGui3d = isGui3d;
            this.transforms = transforms;
            this.overrides = overrides;
        }

        public void addFace(Direction direction, String upgrade, BakedQuad quad) {
            this.faces.get(upgrade).get(direction).add(quad);
        }

        public Builder addParticle(String upgrade, TextureAtlasSprite particle) {
            this.particles.put(upgrade, particle);
            return this;
        }

        public BakedModel build() {
            return new FactoryUpgradeBakedModel(this.faces, this.hasAmbientOcclusion, this.usesBlockLight, this.isGui3d, this.particles, this.transforms, this.overrides);
        }
    }
}

