/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.client.model.factory_upgrade;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.math.Transformation;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.IQuadTransformer;
import net.neoforged.neoforge.client.model.QuadTransformers;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import net.neoforged.neoforge.client.model.geometry.UnbakedGeometryHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import wootrevived.api.WootUpgradeItem;
import wootrevived.woot.Woot;
import wootrevived.woot.client.model.factory_upgrade.FactoryUpgradeBakedModel;
import wootrevived.woot.registries.UpgradeItemsRegistry;

@OnlyIn(value=Dist.CLIENT)
public class FactoryUpgradeUnbakedModel
implements IUnbakedGeometry<FactoryUpgradeUnbakedModel> {
    private final ResourceLocation parentLocation;
    private BlockModel blockModel;

    public FactoryUpgradeUnbakedModel(ResourceLocation parentLocation) {
        this.parentLocation = parentLocation;
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        TextureAtlasSprite factory = spriteGetter.apply(context.getMaterial("north"));
        FactoryUpgradeBakedModel.Builder builder = new FactoryUpgradeBakedModel.Builder(context.useAmbientOcclusion(), context.useBlockLight(), context.isGui3d(), context.getTransforms(), overrides).addParticle("", factory);
        this.addQuads(context, builder, spriteGetter, modelState, modelLocation, factory, "");
        for (DeferredHolder<Item, ? extends WootUpgradeItem> upgradeItem : UpgradeItemsRegistry.getValues()) {
            String name = UpgradeItemsRegistry.getNameFromItem(upgradeItem);
            TextureAtlasSprite texture = spriteGetter.apply(new Material(InventoryMenu.BLOCK_ATLAS, Woot.location("block/upgrade_item_" + name)));
            builder.addParticle(name, texture);
            this.addQuads(context, builder, spriteGetter, modelState, modelLocation, texture, name);
        }
        return builder.build();
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
        UnbakedModel unbakedModel = modelGetter.apply(this.parentLocation);
        unbakedModel.resolveParents(modelGetter);
        if (!(unbakedModel instanceof BlockModel)) {
            throw new RuntimeException("Baking factory_upgrade parent not a block");
        }
        BlockModel model = (BlockModel)unbakedModel;
        this.blockModel = model;
    }

    protected void addQuads(IGeometryBakingContext context, FactoryUpgradeBakedModel.Builder modelBuilder, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ResourceLocation modelLocation, TextureAtlasSprite customSprite, String upgrade) {
        IQuadTransformer postTransform = QuadTransformers.empty();
        Transformation rootTransform = context.getRootTransform();
        if (!rootTransform.isIdentity()) {
            postTransform = UnbakedGeometryHelper.applyRootTransform((ModelState)modelState, (Transformation)rootTransform);
        }
        for (BlockElement element : this.blockModel.getElements()) {
            for (Direction direction : element.faces.keySet()) {
                BlockElementFace face = (BlockElementFace)element.faces.get(direction);
                TextureAtlasSprite sprite = direction != Direction.DOWN && direction != Direction.UP ? customSprite : spriteGetter.apply(context.getMaterial(face.texture));
                BakedQuad quad = BlockModel.bakeFace((BlockElement)element, (BlockElementFace)face, (TextureAtlasSprite)sprite, (Direction)direction, (ModelState)modelState, (ResourceLocation)modelLocation);
                postTransform.processInPlace(quad);
                modelBuilder.addFace(modelState.getRotation().rotateTransform(face.cullForDirection), upgrade, quad);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Loader
    implements IGeometryLoader<FactoryUpgradeUnbakedModel> {
        public static final Loader INSTANCE = new Loader();

        public FactoryUpgradeUnbakedModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            if (!jsonObject.has("parent")) {
                throw new RuntimeException("Model factory_upgrade don't have parent");
            }
            return new FactoryUpgradeUnbakedModel(ResourceLocation.tryParse((String)jsonObject.get("parent").getAsString()));
        }
    }
}

