/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.client.render.dye_liquifier;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.blocks.dye_liquifier.DyeLiquifierBlockEntity;
import wootrevived.woot.recipes.dye_liquifier.DyeLiquifierRecipe;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.util.render.WootContainerMenu;
import wootrevived.woot.util.render.WootSlot;

public class DyeLiquifierContainerMenu
extends WootContainerMenu {
    public static final int DATA_DYE_LIQUIFIER_RED = 10;
    public static final int DATA_DYE_LIQUIFIER_YELLOW = 11;
    public static final int DATA_DYE_LIQUIFIER_BLUE = 12;
    public static final int DATA_DYE_LIQUIFIER_WHITE = 13;
    private final Level level;
    public DyeLiquifierBlockEntity blockEntity;

    public DyeLiquifierContainerMenu(int id, Level level, BlockPos pos, Inventory playerInventory, Player player) {
        super((MenuType)BlocksRegistry.DYE_LIQUIFIER_BLOCK_MENU.get(), id);
        this.level = level;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof DyeLiquifierBlockEntity)) {
            return;
        }
        DyeLiquifierBlockEntity be = (DyeLiquifierBlockEntity)blockEntity;
        this.blockEntity = be;
        this.data = be.data;
        this.createMachineInputSlots(be.getInventory());
        this.createPlayerInventory(playerInventory);
    }

    public DyeLiquifierContainerMenu(int windowId, Inventory inv, FriendlyByteBuf data) {
        this(windowId, inv.player.level(), data.readBlockPos(), inv, inv.player);
    }

    private void createMachineInputSlots(IItemHandler machineInventory) {
        this.addSlot((Slot)new SlotItemHandler(machineInventory, 0, 31, 29));
        this.addSlot((Slot)new SlotItemHandler(machineInventory, 1, 51, 29));
        this.addSlot((Slot)new SlotItemHandler(machineInventory, 2, 31, 49));
        this.addSlot((Slot)new SlotItemHandler(machineInventory, 3, 51, 49));
    }

    private void createPlayerInventory(Inventory playerInventory) {
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventory, k, 8 + k * 18, 160));
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new WootSlot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 102 + i * 18));
            }
        }
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        int endIndex;
        int startIndex;
        Slot slot = (Slot)this.slots.get(index);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = slot.getItem();
        ItemStack stackCopy = stack.copy();
        int MACHINE_INV_SIZE = 4;
        int PLAYER_INV_SIZE = 27;
        int TOOLBAR_INV_SIZE = 9;
        if (index >= 4) {
            if (DyeLiquifierRecipe.Validator.isIngredientValid(stack, DyeLiquifierRecipe.Colors.ANY)) {
                startIndex = 0;
                endIndex = 4;
            } else if (index < 31) {
                startIndex = 31;
                endIndex = startIndex + 9;
            } else {
                startIndex = 4;
                endIndex = startIndex + 27;
            }
        } else {
            startIndex = 4;
            endIndex = startIndex + 27 + 9;
        }
        if (!this.moveItemStackTo(stack, startIndex, endIndex, false)) {
            return ItemStack.EMPTY;
        }
        if (stack.getCount() == 0) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (stack.getCount() == stackCopy.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(player, stack);
        return stackCopy;
    }

    public boolean stillValid(@NotNull Player player) {
        return DyeLiquifierContainerMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)((Block)BlocksRegistry.DYE_LIQUIFIER_BLOCK.get()));
    }

    public int getRedDyeAmount() {
        return this.data.get(10);
    }

    public int getYellowDyeAmount() {
        return this.data.get(11);
    }

    public int getBlueDyeAmount() {
        return this.data.get(12);
    }

    public int getWhiteDyeAmount() {
        return this.data.get(13);
    }
}

