/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.client.render.factory;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.blocks.factory_upgrade.FactoryUpgradeBlockEntity;

@OnlyIn(value=Dist.CLIENT)
public class FactoryBlockEntityRenderer
implements BlockEntityRenderer<BlockEntity> {
    public void render(BlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        boolean isDisabled;
        BlockState blockState = blockEntity.getBlockState();
        Level level = blockEntity.getLevel();
        if (blockState.getRenderShape() == RenderShape.MODEL) {
            if (blockEntity instanceof FactoryUpgradeBlockEntity) {
                FactoryUpgradeBlockEntity factoryUpgradeBlockEntity = (FactoryUpgradeBlockEntity)blockEntity;
                factoryUpgradeBlockEntity.tryRequestModelDataUpdate();
            }
            return;
        }
        BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
        BakedModel blockModel = blockRenderer.getBlockModel(blockState);
        ModelData blockModelData = blockModel.getModelData((BlockAndTintGetter)level, blockEntity.getBlockPos(), blockState, ModelData.EMPTY);
        long seed = blockState.getSeed(blockEntity.getBlockPos());
        boolean isNonAttached = blockState.hasProperty((Property)BlockStateProperties.ATTACHED) && (Boolean)blockState.getValue((Property)BlockStateProperties.ATTACHED) == false;
        boolean bl = isDisabled = blockState.hasProperty((Property)BlockStateProperties.ENABLED) && (Boolean)blockState.getValue((Property)BlockStateProperties.ENABLED) == false;
        float scale = isDisabled ? 0.5f : (isNonAttached ? 0.75f : 1.0f);
        poseStack.pushPose();
        poseStack.translate((1.0f - scale) / 2.0f, (1.0f - scale) / 2.0f, (1.0f - scale) / 2.0f);
        poseStack.scale(scale, scale, scale);
        for (RenderType renderType : blockModel.getRenderTypes(blockState, RandomSource.create((long)seed), blockModelData)) {
            blockRenderer.getModelRenderer().renderModel(poseStack.last(), buffer.getBuffer(RenderTypeHelper.getEntityRenderType((RenderType)renderType, (boolean)false)), blockState, blockModel, 0.0f, 0.0f, 0.0f, packedLight, packedOverlay, blockModelData, renderType);
        }
        poseStack.popPose();
    }
}

