/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.client.render.item_infuser;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.blocks.item_infuser.ItemInfuserBlockEntity;
import wootrevived.woot.recipes.item_infuser.ItemInfuserRecipe;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.util.render.WootContainerMenu;
import wootrevived.woot.util.render.WootSlot;

public class ItemInfuserContainerMenu
extends WootContainerMenu {
    private final Level level;
    public ItemInfuserBlockEntity blockEntity;

    public ItemInfuserContainerMenu(int id, Level level, BlockPos pos, Inventory playerInventory, Player player) {
        super((MenuType)BlocksRegistry.ITEM_INFUSER_BLOCK_MENU.get(), id);
        this.level = level;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof ItemInfuserBlockEntity)) {
            return;
        }
        ItemInfuserBlockEntity be = (ItemInfuserBlockEntity)blockEntity;
        this.blockEntity = be;
        this.data = be.data;
        this.createMachineInputSlots(be.getInventory());
        this.createPlayerInventory(playerInventory);
    }

    public ItemInfuserContainerMenu(int windowId, Inventory inv, FriendlyByteBuf data) {
        this(windowId, inv.player.level(), data.readBlockPos(), inv, inv.player);
    }

    private void createMachineInputSlots(IItemHandler machineInventory) {
        this.addSlot((Slot)new SlotItemHandler(machineInventory, 0, 65, 40));
        this.addSlot((Slot)new SlotItemHandler(machineInventory, 1, 85, 40));
        this.addSlot((Slot)new SlotItemHandler(machineInventory, 2, 141, 40){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return false;
            }
        });
    }

    private void createPlayerInventory(Inventory playerInventory) {
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventory, k, 8 + k * 18, 160));
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new WootSlot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 102 + i * 18));
            }
        }
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        int endIndex;
        int startIndex;
        Slot slot = (Slot)this.slots.get(index);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = slot.getItem();
        ItemStack stackCopy = stack.copy();
        int MACHINE_INV_SIZE = 3;
        int PLAYER_INV_SIZE = 27;
        int TOOLBAR_INV_SIZE = 9;
        if (index >= 3) {
            if (ItemInfuserRecipe.Validator.isIngredientValid(stack)) {
                startIndex = 0;
                endIndex = 1;
            } else if (ItemInfuserRecipe.Validator.isAugmentValid(stack)) {
                startIndex = 1;
                endIndex = 2;
            } else if (index < 30) {
                startIndex = 30;
                endIndex = startIndex + 9;
            } else {
                startIndex = 3;
                endIndex = startIndex + 27;
            }
        } else {
            startIndex = 3;
            endIndex = startIndex + 27 + 9;
        }
        if (!this.moveItemStackTo(stack, startIndex, endIndex, false)) {
            return ItemStack.EMPTY;
        }
        if (stack.getCount() == 0) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (stack.getCount() == stackCopy.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(player, stack);
        return stackCopy;
    }

    public boolean stillValid(@NotNull Player player) {
        return ItemInfuserContainerMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)((Block)BlocksRegistry.ITEM_INFUSER_BLOCK.get()));
    }
}

