/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.client.render.item_infuser;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.client.render.item_infuser.ItemInfuserContainerMenu;
import wootrevived.woot.config.ItemInfuserConfig;
import wootrevived.woot.util.render.WootContainerScreen;

@OnlyIn(value=Dist.CLIENT)
public class ItemInfuserContainerScreen
extends WootContainerScreen<ItemInfuserContainerMenu> {
    private static final int ENERGY_X = 10;
    private static final int ENERGY_Y = 20;
    private static final int INPUT_FLUID_X = 31;
    private static final int INPUT_FLUID_Y = 20;
    private static final int INPUT_FLUID_COLOR = -14339694;
    private static final int INGREDIENT_SLOT_X = 64;
    private static final int INGREDIENT_SLOT_Y = 39;
    private static final int INGREDIENT_SLOT_COLOR = -11763815;
    private static final int AUGMENT_SLOT_X = 84;
    private static final int AUGMENT_SLOT_Y = 39;
    private static final int AUGMENT_SLOT_COLOR = -6737101;
    private static final int OUTPUT_SLOT_X = 140;
    private static final int OUTPUT_SLOT_Y = 39;
    private static final int OUTPUT_SLOT_COLOR = -8401895;
    private static final int PROGRESS_X = 110;
    private static final int PROGRESS_Y = 40;

    public ItemInfuserContainerScreen(ItemInfuserContainerMenu container, Inventory playerInventory, Component name) {
        super(container, playerInventory, name);
    }

    @Override
    protected void initButtons() {
        this.createFluidSideButton(31, 20, -14339694, 0, (Component)Component.translatable((String)"info.woot_revived.input_fluid"));
        this.createSlotSideButton(64, 39, -11763815, 1, (Component)Component.translatable((String)"info.woot_revived.input"));
        this.createSlotSideButton(84, 39, -6737101, 2, (Component)Component.translatable((String)"info.woot_revived.augment_input"));
        this.createSlotSideButton(140, 39, -8401895, 3, (Component)Component.translatable((String)"info.woot_revived.output"));
    }

    @Override
    protected void renderMenuBackground(@NotNull GuiGraphics gui) {
        ItemInfuserContainerScreen.renderSlot(gui, 64, 39, -11763815);
        ItemInfuserContainerScreen.renderSlot(gui, 84, 39, -6737101);
        ItemInfuserContainerScreen.renderSlot(gui, 140, 39, -8401895);
        ItemInfuserContainerScreen.renderEnergyBg(gui, 10, 20);
        ItemInfuserContainerScreen.renderFluidBg(gui, 31, 20);
        ItemInfuserContainerScreen.renderProgressArrowBg(gui, 110, 40);
    }

    @Override
    protected void renderState(@NotNull GuiGraphics gui) {
        ItemInfuserContainerScreen.renderEnergy(gui, 10, 20, ((ItemInfuserContainerMenu)this.menu).getEnergy(), (Integer)ItemInfuserConfig.ENERGY_CAPACITY.get());
        ItemInfuserContainerScreen.renderFluid(gui, 31, 20, ((ItemInfuserContainerMenu)this.menu).getInputFluid(), (Integer)ItemInfuserConfig.INPUT_TANK_CAPACITY.get());
        ItemInfuserContainerScreen.renderProgressArrow(gui, 110, 40, ((ItemInfuserContainerMenu)this.menu).getProgress());
    }

    protected void renderTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY) {
        this.renderEnergyTooltip(gui, mouseX, mouseY, 10, 20, ((ItemInfuserContainerMenu)this.menu).getEnergy(), (Integer)ItemInfuserConfig.ENERGY_CAPACITY.get());
        this.renderFluidTooltip(gui, mouseX, mouseY, 31, 20, ((ItemInfuserContainerMenu)this.menu).getInputFluid(), (Integer)ItemInfuserConfig.INPUT_TANK_CAPACITY.get());
        this.renderProgressArrowTooltip(gui, mouseX, mouseY, 110, 40, ((ItemInfuserContainerMenu)this.menu).getProgress(), ((ItemInfuserContainerMenu)this.menu).getLeftSeconds(), ((ItemInfuserContainerMenu)this.menu).getEnergyProcessTransfer());
    }
}

