/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.client.sprite.factory_upgrade;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceType;
import net.minecraft.client.renderer.texture.atlas.sources.LazyLoadedImage;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceMetadata;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import wootrevived.api.WootUpgradeItem;
import wootrevived.woot.Woot;
import wootrevived.woot.events.client.RegisterSpriteSources;
import wootrevived.woot.registries.UpgradeItemsRegistry;

@OnlyIn(value=Dist.CLIENT)
public record FactoryUpgradeDynamicSpriteSource(ResourceLocation id) implements SpriteSource
{
    public static final Codec<FactoryUpgradeDynamicSpriteSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(FactoryUpgradeDynamicSpriteSource::id)).apply((Applicative)instance, FactoryUpgradeDynamicSpriteSource::new));

    public void run(@NotNull ResourceManager manager, @NotNull SpriteSource.Output output) {
        Collection<DeferredHolder<Item, ? extends WootUpgradeItem>> upgradeItems = UpgradeItemsRegistry.getValues();
        ResourceLocation factoryUpgradeResourceLocation = Woot.location("textures/block/factory_upgrade.png");
        Resource factoryResource = this.getResource(manager, factoryUpgradeResourceLocation);
        LazyLoadedImage factoryImage = new LazyLoadedImage(factoryUpgradeResourceLocation, factoryResource, upgradeItems.size());
        for (DeferredHolder<Item, ? extends WootUpgradeItem> upgradeItem : upgradeItems) {
            ResourceLocation upgradeItemResourceLocation = ((WootUpgradeItem)((Object)upgradeItem.get())).getTextureLocation();
            Resource upgradeItemResource = this.getResource(manager, upgradeItemResourceLocation);
            LazyLoadedImage upgradeItemImage = new LazyLoadedImage(upgradeItemResourceLocation, upgradeItemResource, 1);
            ResourceLocation spriteLocation = Woot.location("block/upgrade_item_" + UpgradeItemsRegistry.getNameFromItem(upgradeItem));
            output.add(spriteLocation, (SpriteSource.SpriteSupplier)new UpgradeSpriteSupplier((WootUpgradeItem)((Object)upgradeItem.get()), factoryImage, upgradeItemImage, spriteLocation));
        }
    }

    private Resource getResource(ResourceManager resourceManager, ResourceLocation resourceLocation) {
        Optional optionalResource = resourceManager.getResource(resourceLocation);
        if (optionalResource.isPresent()) {
            return (Resource)optionalResource.get();
        }
        throw new RuntimeException("Could not find resource: " + String.valueOf(resourceLocation));
    }

    @NotNull
    public SpriteSourceType type() {
        return RegisterSpriteSources.getUpgradeLoader();
    }

    public record UpgradeSpriteSupplier(WootUpgradeItem upgradeItem, LazyLoadedImage lazyFactoryImage, LazyLoadedImage lazyUpgradeImage, ResourceLocation location) implements SpriteSource.SpriteSupplier
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SpriteContents apply(SpriteResourceLoader spriteResourceLoader) {
            try {
                NativeImage factoryUpgradeImage = this.lazyFactoryImage.get();
                NativeImage upgradeItemImage = this.lazyUpgradeImage.get();
                NativeImage imageSide = new NativeImage(factoryUpgradeImage.getWidth(), factoryUpgradeImage.getHeight(), false);
                imageSide.copyFrom(factoryUpgradeImage);
                this.upgradeItem.applyUpgradeTexture(imageSide, upgradeItemImage);
                SpriteContents spriteContents = new SpriteContents(this.location, new FrameSize(imageSide.getWidth(), imageSide.getHeight()), imageSide, ResourceMetadata.EMPTY);
                return spriteContents;
            }
            catch (IOException iOException) {
            }
            finally {
                this.discard();
            }
            return null;
        }

        public void discard() {
            this.lazyFactoryImage.release();
            this.lazyUpgradeImage.release();
        }
    }
}

