/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import wootrevived.api.WootFactoryMob;
import wootrevived.woot.blocks.fake_spawner.FakeSpawnerBlockEntity;
import wootrevived.woot.events.InitDropSimulator;
import wootrevived.woot.registries.WootFactoryMobsRegistry;
import wootrevived.woot.util.helper.SerializeEntityNBTHelper;

public class GiveCommand {
    private static final SuggestionProvider<CommandSourceStack> suggestionProvider = (commandContext, suggestionsBuilder) -> SharedSuggestionProvider.suggestResource(InitDropSimulator.mobLocations, (SuggestionsBuilder)suggestionsBuilder);

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"give").requires(cs -> cs.hasPermission(2))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(((RequiredArgumentBuilder)Commands.argument((String)"entity", (ArgumentType)ResourceLocationArgument.id()).suggests(suggestionProvider).executes(ctx -> GiveCommand.giveItem((CommandSourceStack)ctx.getSource(), EntityArgument.getPlayer((CommandContext)ctx, (String)"target"), ResourceLocationArgument.getId((CommandContext)ctx, (String)"entity"), new CompoundTag()))).then(Commands.argument((String)"nbt", (ArgumentType)CompoundTagArgument.compoundTag()).executes(ctx -> GiveCommand.giveItem((CommandSourceStack)ctx.getSource(), EntityArgument.getPlayer((CommandContext)ctx, (String)"target"), ResourceLocationArgument.getId((CommandContext)ctx, (String)"entity"), CompoundTagArgument.getCompoundTag((CommandContext)ctx, (String)"nbt"))))));
    }

    private static int giveItem(CommandSourceStack source, ServerPlayer target, ResourceLocation resourceLocation, CompoundTag tag) {
        EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(resourceLocation);
        if (entityType == null || !WootFactoryMobsRegistry.hasFactoryMob(entityType)) {
            return 1;
        }
        WootFactoryMob<?> mob = WootFactoryMobsRegistry.getFactoryMob(entityType);
        if (mob.isBlacklisted()) {
            return 1;
        }
        tag.putString("id", resourceLocation.toString());
        EntityType.create((CompoundTag)tag, (Level)source.getLevel()).filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast).ifPresent(entity -> {
            CompoundTag mobTag = mob.saveTag(SerializeEntityNBTHelper.serialize((Entity)entity), (HolderLookup.Provider)source.getLevel().registryAccess());
            ItemStack fakeSpawner = FakeSpawnerBlockEntity.getItemStack(mobTag);
            ItemHandlerHelper.giveItemToPlayer((Player)target, (ItemStack)fakeSpawner);
        });
        return 1;
    }
}

