/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.compat.jade;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.IItemHandler;
import snownee.jade.addon.universal.FluidStorageProvider;
import snownee.jade.addon.universal.ItemCollector;
import snownee.jade.addon.universal.ItemIterator;
import snownee.jade.addon.universal.ItemStorageProvider;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.util.JadeForgeUtils;
import wootrevived.woot.Woot;
import wootrevived.woot.util.entity.WootMachineBlockEntity;
import wootrevived.woot.util.handlers.WootFluidTankHandler;

public enum WootMachineProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        CompoundTag tag = blockAccessor.getServerData();
        if (tag.contains("Progress")) {
            IElementHelper helper = IElementHelper.get();
            float progress = (float)blockAccessor.getServerData().getInt("Progress") / 100.0f;
            BoxStyle.GradientBorder box = BoxStyle.getTransparent().clone();
            box.bgColor = -2013265920;
            iTooltip.add(helper.progress(progress, null, helper.progressStyle(), (BoxStyle)box, false).size(new Vec2(10.0f, 4.0f)));
        }
    }

    public ResourceLocation getUid() {
        return Woot.location("machines");
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor blockAccessor) {
        BlockEntity blockEntity = blockAccessor.getBlockEntity();
        if (blockEntity instanceof WootMachineBlockEntity) {
            WootMachineBlockEntity machine = (WootMachineBlockEntity)blockEntity;
            this.putItemData(compoundTag, blockAccessor, machine);
            this.putFluidData(compoundTag, blockAccessor, machine);
            this.putProgressData(compoundTag, blockAccessor, machine);
        }
    }

    private void putItemData(CompoundTag compoundTag, BlockAccessor blockAccessor, WootMachineBlockEntity machine) {
        IItemHandler inventory = machine.getInventory();
        SimpleContainer container = new SimpleContainer(inventory.getSlots());
        for (int i = 0; i < inventory.getSlots(); ++i) {
            container.addItem(inventory.getStackInSlot(i));
        }
        ItemCollector items = new ItemCollector((ItemIterator)new ItemIterator.ContainerItemIterator(0));
        List viewsList = items.update((Accessor)blockAccessor, blockAccessor.getLevel().getGameTime());
        if (ViewGroup.saveList((CompoundTag)compoundTag, (String)"JadeItemStorage", (List)viewsList, item -> {
            CompoundTag itemTag = new CompoundTag();
            int count = item.getCount();
            if (count > 64) {
                item.setCount(1);
            }
            item.save(itemTag);
            if (count > 64) {
                itemTag.putInt("NewCount", count);
                item.setCount(count);
            }
            return itemTag;
        })) {
            compoundTag.putString("JadeItemStorageUid", ItemStorageProvider.INSTANCE.getUid().toString());
        }
    }

    private void putFluidData(CompoundTag compoundTag, BlockAccessor blockAccessor, WootMachineBlockEntity machine) {
        FluidStack fluidStack;
        WootFluidTankHandler tank;
        int capacity;
        CompoundTag inputFluid = null;
        int inputEmptyCapacity = 0;
        CompoundTag outputFluid = null;
        int outputEmptyCapacity = 0;
        if (machine.hasInputFluidCapability() && (capacity = (tank = machine.getInputTank()).getCapacity()) > 0) {
            fluidStack = tank.getFluid();
            if (fluidStack.isEmpty()) {
                inputEmptyCapacity = capacity;
            } else {
                inputFluid = JadeForgeUtils.fromFluidStack((FluidStack)fluidStack, (long)capacity);
            }
        }
        if (machine.hasOutputFluidCapability() && (capacity = (tank = machine.getOutputTank()).getCapacity()) > 0) {
            fluidStack = tank.getFluid();
            if (fluidStack.isEmpty()) {
                outputEmptyCapacity = capacity;
            } else {
                outputFluid = JadeForgeUtils.fromFluidStack((FluidStack)fluidStack, (long)capacity);
            }
        }
        if (inputFluid == null && inputEmptyCapacity > 0) {
            inputFluid = JadeForgeUtils.fromFluidStack((FluidStack)FluidStack.EMPTY, (long)inputEmptyCapacity);
        }
        if (outputFluid == null && outputEmptyCapacity > 0) {
            outputFluid = JadeForgeUtils.fromFluidStack((FluidStack)FluidStack.EMPTY, (long)outputEmptyCapacity);
        }
        ArrayList<CompoundTag> fluids = new ArrayList<CompoundTag>(2);
        if (inputFluid != null) {
            fluids.add(inputFluid);
        }
        if (outputFluid != null) {
            fluids.add(outputFluid);
        }
        if (ViewGroup.saveList((CompoundTag)compoundTag, (String)"JadeFluidStorage", fluids.isEmpty() ? null : List.of(new ViewGroup(fluids)), Function.identity())) {
            compoundTag.putString("JadeFluidStorageUid", FluidStorageProvider.INSTANCE.getUid().toString());
        }
    }

    private void putProgressData(CompoundTag compoundTag, BlockAccessor blockAccessor, WootMachineBlockEntity machine) {
        if (machine.isProcessActive()) {
            compoundTag.putInt("Progress", machine.calculateProgress());
        }
    }
}

