/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.compat.jei;

import java.util.List;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.util.render.WootContainerScreen;
import wootrevived.woot.util.render.WootStyles;

public class WootJeiCustomFluidRenderer
implements IIngredientRenderer<FluidStack> {
    private final int capacity;

    public WootJeiCustomFluidRenderer(int capacity) {
        this.capacity = capacity;
    }

    public void render(@NotNull GuiGraphics gui, @NotNull FluidStack ingredient) {
        WootContainerScreen.renderFluid(gui, -3, -3, ingredient, this.capacity);
    }

    @NotNull
    public List<Component> getTooltip(FluidStack ingredient, @NotNull TooltipFlag tooltipFlag) {
        return List.of(Component.empty().append((Component)Component.translatable((String)"info.woot_revived.fluid").append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE)).append((Component)(ingredient != null && !ingredient.isEmpty() ? ingredient.getDisplayName() : Component.translatable((String)"info.woot_revived.empty"))), Component.empty().append((Component)Component.translatable((String)"info.woot_revived.amount").append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE)).append(WootContainerScreen.formatInteger(ingredient.getAmount())).append((Component)Component.literal((String)"mB").setStyle(WootStyles.UNIT_STYLE)));
    }

    public int getWidth() {
        return 12;
    }

    public int getHeight() {
        return 50;
    }
}

