/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.compat.kubejs.mobs;

import dev.architectury.fluid.FluidStack;
import dev.latvian.mods.kubejs.event.StartupEventJS;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.item.OutputItem;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import wootrevived.api.interfaces.WootDropsProperties;
import wootrevived.woot.util.helper.EnchantmentHelper;

public class WootDropsPropertiesJS
extends StartupEventJS {
    private final WootDropsProperties properties;

    public WootDropsProperties getRawProperties() {
        return this.properties;
    }

    public WootDropsPropertiesJS(WootDropsProperties properties) {
        this.properties = properties;
    }

    public int getEnchantmentLevel(String enchantmentId) {
        return this.getEnchantmentLevel(enchantmentId, "MAIN_HAND");
    }

    public int getEnchantmentLevel(String enchantmentId, String handId) {
        ItemStack stack;
        ResourceLocation id = ResourceLocation.tryParse((String)enchantmentId);
        Enchantment enchantment = (Enchantment)BuiltInRegistries.ENCHANTMENT.get(id);
        if (enchantment == null) {
            return 0;
        }
        InteractionHand hand = InteractionHand.MAIN_HAND;
        try {
            hand = InteractionHand.valueOf((String)handId);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        switch (hand) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case MAIN_HAND: {
                ItemStack itemStack = this.properties.getMainHandItem();
                break;
            }
            case OFF_HAND: {
                ItemStack itemStack = stack = this.properties.getOffHandItem();
            }
        }
        if (!EnchantmentHelper.isEnchanted(stack)) {
            return 0;
        }
        return stack.getEnchantmentLevel(enchantment);
    }

    public OutputItem[] getItemDrops() {
        List<ItemStack> stacks = this.properties.getItemDrops();
        return (OutputItem[])stacks.stream().map(OutputItem::of).toArray(OutputItem[]::new);
    }

    public void setItemDrops(OutputItem[] items) {
        List<ItemStack> stacks = this.properties.getItemDrops();
        stacks.clear();
        stacks.addAll(Arrays.stream(items).map(o -> o.item).toList());
    }

    public FluidStackJS[] getFluidDrops() {
        List<net.neoforged.neoforge.fluids.FluidStack> stacks = this.properties.getFluidDrops();
        return (FluidStackJS[])stacks.stream().map(f -> FluidStack.create(() -> ((net.neoforged.neoforge.fluids.FluidStack)f).getFluid(), (long)f.getAmount(), (CompoundTag)f.getTag())).map(FluidStackJS::of).toArray(FluidStackJS[]::new);
    }

    public void setFluidDrops(FluidStackJS[] items) {
        List<net.neoforged.neoforge.fluids.FluidStack> stacks = this.properties.getFluidDrops();
        stacks.clear();
        stacks.addAll(Arrays.stream(items).map(FluidStackJS::getFluidStack).map(f -> new net.neoforged.neoforge.fluids.FluidStack(f.getFluid(), (int)f.getAmount(), f.getTag())).toList());
    }

    public String getFactoryTier() {
        return this.properties.getFactoryTier().getSerializedName();
    }

    public RandomSource getRandom() {
        return this.properties.getRandom();
    }

    public int getExperience() {
        return this.properties.getExperience();
    }

    public void setExperience(int experience) {
        this.properties.setExperience(experience);
    }

    public float getLuck() {
        return this.properties.getLuck();
    }

    public boolean doSimulateChargedCreeper() {
        return this.properties.doSimulateChargedCreeper();
    }

    public boolean isEnderDragonAlreadyKilled() {
        return this.properties.isEnderDragonAlreadyKilled();
    }

    public boolean isInFire() {
        return this.properties.isInFire();
    }

    public String getDimension() {
        return this.properties.getDimension().location().toString();
    }
}

