/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.datagen;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.registries.FluidsRegistry;
import wootrevived.woot.registries.ItemsRegistry;
import wootrevived.woot.registries.UpgradeItemsRegistry;
import wootrevived.woot.upgrades.ShardDrop;

public class Advancements
extends AdvancementProvider {
    public Advancements(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper) {
        super(output, registries, existingFileHelper, List.of(new Generator()));
    }

    public static final class Generator
    implements AdvancementProvider.AdvancementGenerator {
        private static final ResourceLocation background = ResourceLocation.tryParse((String)"textures/block/black_concrete_powder.png");

        public void generate(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider registries, @NotNull Consumer<AdvancementHolder> saver, @NotNull ExistingFileHelper existingFileHelper) {
            AdvancementHolder wootRevived = Advancement.Builder.advancement().display((ItemLike)BlocksRegistry.HEART_BLOCK.get(), (Component)Component.translatable((String)"advancements.woot_revived.root.title"), (Component)Component.translatable((String)"advancements.woot_revived.root.description"), background, AdvancementType.TASK, false, false, false).addCriterion("killed_something", KilledTrigger.TriggerInstance.playerKilledEntity()).save(saver, this.getNameId("root"));
            AdvancementHolder stygian_ingot = this.registerItem(saver, "stygian_ingot", wootRevived, (ItemLike)ItemsRegistry.STYGIAN_INGOT_ITEM.get());
            AdvancementHolder stygian_hammer = this.registerItem(saver, "stygian_hammer", stygian_ingot, (ItemLike)ItemsRegistry.STYGIAN_HAMMER_ITEM.get());
            AdvancementHolder stygian_anvil = this.registerItem(saver, "stygian_anvil", stygian_ingot, (ItemLike)BlocksRegistry.STYGIAN_ANVIL_BLOCK.get());
            AdvancementHolder shard_mold = this.registerItem(saver, "shard_mold", stygian_anvil, (ItemLike)ItemsRegistry.SHARD_MOLD_ITEM.get());
            AdvancementHolder dye_mold = this.registerItem(saver, "dye_mold", stygian_anvil, (ItemLike)ItemsRegistry.DYE_CASING_MOLD_ITEM.get());
            AdvancementHolder plate_mold = this.registerItem(saver, "plate_mold", stygian_anvil, (ItemLike)ItemsRegistry.PLATE_MOLD_ITEM.get());
            AdvancementHolder mob_shard = this.registerItem(saver, "mob_shard", shard_mold, (ItemLike)ItemsRegistry.MOB_SHARD_ITEM.get());
            AdvancementHolder stygian_plate = this.registerItem(saver, "stygian_plate", plate_mold, (ItemLike)ItemsRegistry.STYGIAN_PLATE_ITEM.get());
            AdvancementHolder factory_base = this.registerItem(saver, "factory_base", stygian_plate, (ItemLike)BlocksRegistry.FACTORY_BASE_BLOCK.get());
            AdvancementHolder fluid_infuser = this.registerItem(saver, "fluid_infuser", factory_base, (ItemLike)BlocksRegistry.FLUID_INFUSER_BLOCK.get());
            AdvancementHolder mob_tears_bucket = this.registerItem(saver, "mob_tears_bucket", fluid_infuser, (ItemLike)FluidsRegistry.MOB_TEARS_FLUID_BUCKET.get());
            AdvancementHolder vitality_fuel_bucket = this.registerItem(saver, "vitality_fuel_bucket", mob_tears_bucket, (ItemLike)FluidsRegistry.VITALITY_FUEL_FLUID_BUCKET.get());
            AdvancementHolder enchanted_liquifier = this.registerItem(saver, "enchanted_liquifier", factory_base, (ItemLike)BlocksRegistry.ENCHANTED_LIQUIFIER_BLOCK.get());
            AdvancementHolder enchanted_bucket = this.registerItem(saver, "enchanted_bucket", enchanted_liquifier, (ItemLike)FluidsRegistry.ENCHANTED_FLUID_BUCKET.get());
            AdvancementHolder item_infuser = this.registerItem(saver, "item_infuser", enchanted_bucket, (ItemLike)BlocksRegistry.ITEM_INFUSER_BLOCK.get());
            AdvancementHolder enchanted_copper_plate = this.registerItem(saver, "enchanted_copper_plate", item_infuser, (ItemLike)ItemsRegistry.COPPER_ENCHANTED_PLATE_ITEM.get());
            AdvancementHolder copper_cell = this.registerItem(saver, "copper_cell", enchanted_copper_plate, (ItemLike)BlocksRegistry.COPPER_CELL_BLOCK.get());
            AdvancementHolder enchanted_iron_plate = this.registerItem(saver, "enchanted_iron_plate", item_infuser, (ItemLike)ItemsRegistry.IRON_ENCHANTED_PLATE_ITEM.get());
            AdvancementHolder iron_cell = this.registerItem(saver, "iron_cell", enchanted_iron_plate, (ItemLike)BlocksRegistry.IRON_CELL_BLOCK.get());
            AdvancementHolder enchanted_gold_plate = this.registerItem(saver, "enchanted_gold_plate", item_infuser, (ItemLike)ItemsRegistry.GOLD_ENCHANTED_PLATE_ITEM.get());
            AdvancementHolder gold_cell = this.registerItem(saver, "gold_cell", enchanted_gold_plate, (ItemLike)BlocksRegistry.GOLD_CELL_BLOCK.get());
            AdvancementHolder enchanted_diamond_plate = this.registerItem(saver, "enchanted_diamond_plate", item_infuser, (ItemLike)ItemsRegistry.DIAMOND_ENCHANTED_PLATE_ITEM.get());
            AdvancementHolder diamond_cell = this.registerItem(saver, "diamond_cell", enchanted_diamond_plate, (ItemLike)BlocksRegistry.DIAMOND_CELL_BLOCK.get());
            AdvancementHolder enchanted_netherite_plate = this.registerItem(saver, "enchanted_netherite_plate", item_infuser, (ItemLike)ItemsRegistry.NETHERITE_ENCHANTED_PLATE_ITEM.get());
            AdvancementHolder netherite_cell = this.registerItem(saver, "netherite_cell", enchanted_netherite_plate, (ItemLike)BlocksRegistry.NETHERITE_CELL_BLOCK.get());
            AdvancementHolder dye_liquifier = this.registerItem(saver, "dye_liquifier", factory_base, (ItemLike)BlocksRegistry.DYE_LIQUIFIER_BLOCK.get());
            AdvancementHolder pure_dye = this.registerItem(saver, "pure_dye", dye_liquifier, (ItemLike)FluidsRegistry.PURE_DYE_FLUID_BUCKET.get());
            AdvancementHolder prism = this.registerItem(saver, "prism", pure_dye, (ItemLike)ItemsRegistry.PRISM_ITEM.get());
            AdvancementHolder fake_spawner = this.registerItem(saver, "fake_spawner", prism, (ItemLike)BlocksRegistry.FAKE_SPAWNER_BLOCK.get());
            AdvancementHolder black_dye_plate = this.registerItem(saver, "black_dye_plate", dye_mold, (ItemLike)ItemsRegistry.BLACK_DYE_PLATE_ITEM.get());
            AdvancementHolder upgrade_base = this.registerItem(saver, "upgrade_base", black_dye_plate, (ItemLike)UpgradeItemsRegistry.UPGRADE_BASE_ITEM.get());
            AdvancementHolder copper_shard = this.registerItem(saver, "copper_shard", shard_mold, (ItemLike)ItemsRegistry.COPPER_SHARD_ITEM.get());
            AdvancementHolder copper_pylon = this.registerItem(saver, "copper_pylon", copper_shard, (ItemLike)BlocksRegistry.COPPER_PYLON_BLOCK.get());
            AdvancementHolder copper_plinth = this.registerItem(saver, "copper_plinth", copper_shard, (ItemLike)BlocksRegistry.COPPER_PLINTH_BLOCK.get());
            AdvancementHolder iron_shard_upgrade = this.registerItem(saver, "iron_shard_upgrade", upgrade_base, (ItemLike)ShardDrop.IRON_SHARD_DROP_ITEM.get());
            AdvancementHolder iron_shard = this.registerItem(saver, "iron_shard", iron_shard_upgrade, (ItemLike)ItemsRegistry.IRON_SHARD_ITEM.get());
            AdvancementHolder iron_pylon = this.registerItem(saver, "iron_pylon", iron_shard, (ItemLike)BlocksRegistry.IRON_PYLON_BLOCK.get());
            AdvancementHolder iron_plinth = this.registerItem(saver, "iron_plinth", iron_shard, (ItemLike)BlocksRegistry.IRON_PLINTH_BLOCK.get());
            AdvancementHolder gold_shard_upgrade = this.registerItem(saver, "gold_shard_upgrade", iron_shard_upgrade, (ItemLike)ShardDrop.GOLD_SHARD_DROP_ITEM.get());
            AdvancementHolder gold_shard = this.registerItem(saver, "gold_shard", gold_shard_upgrade, (ItemLike)ItemsRegistry.GOLD_SHARD_ITEM.get());
            AdvancementHolder gold_pylon = this.registerItem(saver, "gold_pylon", gold_shard, (ItemLike)BlocksRegistry.GOLD_PYLON_BLOCK.get());
            AdvancementHolder gold_plinth = this.registerItem(saver, "gold_plinth", gold_shard, (ItemLike)BlocksRegistry.GOLD_PLINTH_BLOCK.get());
            AdvancementHolder diamond_shard_upgrade = this.registerItem(saver, "diamond_shard_upgrade", gold_shard_upgrade, (ItemLike)ShardDrop.DIAMOND_SHARD_DROP_ITEM.get());
            AdvancementHolder diamond_shard = this.registerItem(saver, "diamond_shard", diamond_shard_upgrade, (ItemLike)ItemsRegistry.DIAMOND_SHARD_ITEM.get());
            AdvancementHolder diamond_pylon = this.registerItem(saver, "diamond_pylon", diamond_shard, (ItemLike)BlocksRegistry.DIAMOND_PYLON_BLOCK.get());
            AdvancementHolder diamond_plinth = this.registerItem(saver, "diamond_plinth", diamond_shard, (ItemLike)BlocksRegistry.DIAMOND_PLINTH_BLOCK.get());
            AdvancementHolder netherite_shard_upgrade = this.registerItem(saver, "netherite_shard_upgrade", diamond_shard_upgrade, (ItemLike)ShardDrop.NETHERITE_SHARD_DROP_ITEM.get());
            AdvancementHolder netherite_shard = this.registerItem(saver, "netherite_shard", netherite_shard_upgrade, (ItemLike)ItemsRegistry.NETHERITE_SHARD_ITEM.get());
            AdvancementHolder netherite_pylon = this.registerItem(saver, "netherite_pylon", netherite_shard, (ItemLike)BlocksRegistry.NETHERITE_PYLON_BLOCK.get());
            AdvancementHolder netherite_plinth = this.registerItem(saver, "netherite_plinth", netherite_shard, (ItemLike)BlocksRegistry.NETHERITE_PLINTH_BLOCK.get());
        }

        private AdvancementHolder registerItem(Consumer<AdvancementHolder> saver, String name, AdvancementHolder parent, ItemLike item) {
            return Advancement.Builder.advancement().parent(parent).display((ItemLike)item.asItem(), (Component)Component.translatable((String)("advancements.woot_revived." + name + ".title")), (Component)Component.translatable((String)("advancements.woot_revived." + name + ".description")), background, AdvancementType.TASK, false, true, false).addCriterion(name, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{item})).save(saver, this.getNameId(name));
        }

        private String getNameId(String id) {
            return "woot_revived:main/" + id;
        }
    }
}

