/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.datagen;

import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;
import wootrevived.woot.Woot;
import wootrevived.woot.client.model.factory_upgrade.FactoryUpgradeModelBuilder;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.registries.FluidsRegistry;
import wootrevived.woot.util.fluid.WootFluidType;

public class Blocks
extends BlockStateProvider {
    private final ResourceLocation FACTORY_BASE = Woot.location("block/factory_base");
    private final ResourceLocation CREATIVE_BASE = Woot.location("block/creative_base");

    public Blocks(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "woot_revived", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.anvil(BlocksRegistry.STYGIAN_ANVIL_BLOCK);
        this.cubeAll(BlocksRegistry.FACTORY_BASE_BLOCK);
        this.cubeAll(BlocksRegistry.STYGIAN_BLOCK);
        this.cubeColumn(BlocksRegistry.FAKE_SPAWNER_BLOCK);
        this.cubeAll(BlocksRegistry.COPPER_CELL_BLOCK);
        this.cubeColumn(BlocksRegistry.COPPER_PLINTH_BLOCK);
        this.cubeColumn(BlocksRegistry.COPPER_PYLON_BLOCK);
        this.cubeAll(BlocksRegistry.IRON_CELL_BLOCK);
        this.cubeColumn(BlocksRegistry.IRON_PLINTH_BLOCK);
        this.cubeColumn(BlocksRegistry.IRON_PYLON_BLOCK);
        this.cubeAll(BlocksRegistry.GOLD_CELL_BLOCK);
        this.cubeColumn(BlocksRegistry.GOLD_PLINTH_BLOCK);
        this.cubeColumn(BlocksRegistry.GOLD_PYLON_BLOCK);
        this.cubeAll(BlocksRegistry.DIAMOND_CELL_BLOCK);
        this.cubeColumn(BlocksRegistry.DIAMOND_PLINTH_BLOCK);
        this.cubeColumn(BlocksRegistry.DIAMOND_PYLON_BLOCK);
        this.cubeAll(BlocksRegistry.NETHERITE_CELL_BLOCK);
        this.cubeColumn(BlocksRegistry.NETHERITE_PLINTH_BLOCK);
        this.cubeColumn(BlocksRegistry.NETHERITE_PYLON_BLOCK);
        this.cubeColumn(BlocksRegistry.FACTORY_CONNECT_BLOCK);
        this.cubeColumn(BlocksRegistry.FACTORY_CTR_BASE_PRI_BLOCK);
        this.cubeColumn(BlocksRegistry.FACTORY_CTR_BASE_SEC_BLOCK);
        this.cubeColumn(BlocksRegistry.IMPORT_BLOCK);
        this.cubeColumn(BlocksRegistry.EXPORT_BLOCK);
        this.upgrade(BlocksRegistry.FACTORY_UPGRADE_BLOCK);
        this.cubeColumnCreative(BlocksRegistry.CREATIVE_TANK_BLOCK);
        this.cubeColumnCreative(BlocksRegistry.CREATIVE_POWER_BLOCK);
        this.orientable(BlocksRegistry.HEART_BLOCK);
        this.orientable(BlocksRegistry.FLUID_INFUSER_BLOCK);
        this.orientable(BlocksRegistry.ITEM_INFUSER_BLOCK);
        this.orientable(BlocksRegistry.DYE_LIQUIFIER_BLOCK);
        this.orientable(BlocksRegistry.ENCHANTED_LIQUIFIER_BLOCK);
        this.layout(BlocksRegistry.LAYOUT_BLOCK);
        this.fluid(FluidsRegistry.VITALITY_FUEL_FLUID_BLOCK, FluidsRegistry.VITALITY_FUEL_FLUID_TYPE);
        this.fluid(FluidsRegistry.ENCHANTED_FLUID_BLOCK, FluidsRegistry.ENCHANTED_FLUID_TYPE);
        this.fluid(FluidsRegistry.MOB_TEARS_FLUID_BLOCK, FluidsRegistry.MOB_TEARS_FLUID_TYPE);
        this.fluid(FluidsRegistry.PURE_DYE_FLUID_BLOCK, FluidsRegistry.PURE_DYE_FLUID_TYPE);
    }

    public ResourceLocation getBlockResource(Block block) {
        return Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)block));
    }

    public void fluid(DeferredHolder<Block, ? extends Block> block, DeferredHolder<FluidType, ? extends FluidType> fluid) {
        ResourceLocation blockResource = this.getBlockResource((Block)block.get());
        WootFluidType fluidType = (WootFluidType)((Object)fluid.get());
        ModelBuilder model = ((BlockModelBuilder)this.models().getBuilder(blockResource.getPath())).texture("particle", fluidType.getStillTexture());
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block.get());
        builder.partialState().modelForState().modelFile((ModelFile)model).addModel();
    }

    public void orientable(DeferredHolder<Block, ? extends Block> block) {
        ResourceLocation blockResource = this.getBlockResource((Block)block.get());
        this.horizontalBlock((Block)block.get(), this.FACTORY_BASE, blockResource.withPrefix("block/"), this.FACTORY_BASE);
    }

    public void cubeAll(DeferredHolder<Block, ? extends Block> block) {
        ResourceLocation blockResource = this.getBlockResource((Block)block.get());
        ModelBuilder model = this.models().cubeAll(blockResource.getPath(), blockResource.withPrefix("block/"));
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block.get());
        builder.partialState().modelForState().modelFile((ModelFile)model).addModel();
    }

    public void cubeColumn(DeferredHolder<Block, ? extends Block> block) {
        ResourceLocation blockResource = this.getBlockResource((Block)block.get());
        ModelBuilder model = this.models().cubeColumn(blockResource.getPath(), blockResource.withPrefix("block/"), this.FACTORY_BASE);
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block.get());
        builder.partialState().modelForState().modelFile((ModelFile)model).addModel();
    }

    public void cubeColumnCreative(DeferredHolder<Block, ? extends Block> block) {
        ResourceLocation blockResource = this.getBlockResource((Block)block.get());
        ModelBuilder model = this.models().cubeColumn(blockResource.getPath(), blockResource.withPrefix("block/"), this.CREATIVE_BASE);
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block.get());
        builder.partialState().modelForState().modelFile((ModelFile)model).addModel();
    }

    public void upgrade(DeferredHolder<Block, ? extends Block> block) {
        ResourceLocation blockResource = this.getBlockResource((Block)block.get());
        ModelBuilder model = ((FactoryUpgradeModelBuilder)((BlockModelBuilder)this.models().cubeColumn(blockResource.getPath(), blockResource.withPrefix("block/"), this.FACTORY_BASE)).customLoader(FactoryUpgradeModelBuilder::new)).end();
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block.get());
        builder.partialState().modelForState().modelFile((ModelFile)model).addModel();
    }

    public void layout(DeferredHolder<Block, ? extends Block> block) {
        ResourceLocation blockResource = this.getBlockResource((Block)block.get());
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockResource.getPath(), ResourceLocation.tryBuild((String)"minecraft", (String)"block/block"))).texture("particle", blockResource.withPrefix("block/"))).texture("end", blockResource.withPrefix("block/"))).texture("primary", blockResource.withPrefix("block/").withSuffix("_primary"))).texture("secondary", blockResource.withPrefix("block/").withSuffix("_secondary"))).transforms().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, 135.0f, 0.0f).scale(0.4f, 0.4f, 0.4f).end().end()).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).face(Direction.DOWN).texture("#end").rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).cullface(Direction.DOWN).end().face(Direction.UP).texture("#end").cullface(Direction.UP).end().face(Direction.NORTH).texture("#primary").cullface(Direction.NORTH).end().face(Direction.SOUTH).texture("#secondary").cullface(Direction.SOUTH).end().face(Direction.WEST).texture("#secondary").cullface(Direction.WEST).end().face(Direction.EAST).texture("#secondary").cullface(Direction.EAST).end().end();
        this.horizontalBlock((Block)block.get(), (ModelFile)model);
    }

    public void anvil(DeferredHolder<Block, ? extends Block> block) {
        ResourceLocation blockResource = this.getBlockResource((Block)block.get());
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockResource.getPath(), ResourceLocation.tryBuild((String)"minecraft", (String)"block/block"))).texture("particle", blockResource.withPrefix("block/"))).texture("base", ResourceLocation.tryBuild((String)"minecraft", (String)"block/crying_obsidian"))).texture("body", blockResource.withPrefix("block/"))).texture("top", blockResource.withPrefix("block/").withSuffix("_top"))).transforms().transform(ItemDisplayContext.FIXED).rotation(0.0f, 90.0f, 0.0f).scale(0.5f, 0.5f, 0.5f).end().end()).element().from(2.0f, 0.0f, 2.0f).to(14.0f, 4.0f, 14.0f).face(Direction.DOWN).uvs(2.0f, 2.0f, 14.0f, 14.0f).texture("#base").rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).cullface(Direction.DOWN).end().face(Direction.UP).uvs(2.0f, 2.0f, 14.0f, 14.0f).texture("#base").rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).end().face(Direction.NORTH).uvs(2.0f, 12.0f, 14.0f, 16.0f).texture("#base").end().face(Direction.SOUTH).uvs(2.0f, 12.0f, 14.0f, 16.0f).texture("#base").end().face(Direction.WEST).uvs(0.0f, 2.0f, 4.0f, 14.0f).texture("#base").rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).end().face(Direction.EAST).uvs(4.0f, 2.0f, 0.0f, 14.0f).texture("#base").rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).end().end()).element().from(4.0f, 4.0f, 3.0f).to(12.0f, 5.0f, 13.0f).face(Direction.UP).uvs(4.0f, 3.0f, 12.0f, 13.0f).texture("#body").rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).end().face(Direction.NORTH).uvs(4.0f, 11.0f, 12.0f, 12.0f).texture("#body").end().face(Direction.SOUTH).uvs(4.0f, 11.0f, 12.0f, 12.0f).texture("#body").end().face(Direction.WEST).uvs(4.0f, 3.0f, 5.0f, 13.0f).texture("#body").rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).end().face(Direction.EAST).uvs(5.0f, 3.0f, 4.0f, 13.0f).texture("#body").rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).end().end()).element().from(6.0f, 5.0f, 4.0f).to(10.0f, 10.0f, 12.0f).face(Direction.NORTH).uvs(6.0f, 6.0f, 10.0f, 11.0f).texture("#body").end().face(Direction.SOUTH).uvs(6.0f, 6.0f, 10.0f, 11.0f).texture("#body").end().face(Direction.WEST).uvs(5.0f, 4.0f, 10.0f, 12.0f).texture("#body").rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).end().face(Direction.EAST).uvs(10.0f, 4.0f, 5.0f, 12.0f).texture("#body").rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).end().end()).element().from(3.0f, 10.0f, 0.0f).to(13.0f, 16.0f, 16.0f).face(Direction.DOWN).uvs(3.0f, 0.0f, 13.0f, 16.0f).texture("#body").rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).end().face(Direction.UP).uvs(3.0f, 0.0f, 13.0f, 16.0f).texture("#top").rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).end().face(Direction.NORTH).uvs(3.0f, 0.0f, 13.0f, 6.0f).texture("#body").end().face(Direction.SOUTH).uvs(3.0f, 0.0f, 13.0f, 6.0f).texture("#body").end().face(Direction.WEST).uvs(10.0f, 0.0f, 16.0f, 16.0f).texture("#body").rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).end().face(Direction.EAST).uvs(16.0f, 0.0f, 10.0f, 16.0f).texture("#body").rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).end().end();
        this.horizontalBlock((Block)block.get(), (ModelFile)model);
    }
}

