/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.datagen;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.registries.BlocksRegistry;

public class LootTables
extends BlockLootSubProvider {
    public LootTables() {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags());
    }

    @NotNull
    protected Iterable<Block> getKnownBlocks() {
        return BlocksRegistry.BLOCKS.getEntries().stream().map(DeferredHolder::get).collect(Collectors.toList());
    }

    protected void generate() {
        this.dropSelf(BlocksRegistry.STYGIAN_ANVIL_BLOCK);
        this.dropSelf(BlocksRegistry.FACTORY_BASE_BLOCK);
        this.dropSelf(BlocksRegistry.STYGIAN_BLOCK);
        this.copyTagWithEnable(BlocksRegistry.FAKE_SPAWNER_BLOCK, (LootItemFunction.Builder)CopyNbtFunction.copyData((NbtProvider)ContextNbtProvider.BLOCK_ENTITY).copy("Mob", "BlockEntityTag.Mob", CopyNbtFunction.MergeStrategy.REPLACE));
        this.dropSelfWithEnable(BlocksRegistry.COPPER_PLINTH_BLOCK);
        this.dropSelfWithEnable(BlocksRegistry.COPPER_PYLON_BLOCK);
        this.copyTagWithEnable(BlocksRegistry.COPPER_CELL_BLOCK, (LootItemFunction.Builder)CopyNbtFunction.copyData((NbtProvider)ContextNbtProvider.BLOCK_ENTITY).copy("InputTank", "BlockEntityTag.InputTank", CopyNbtFunction.MergeStrategy.REPLACE));
        this.dropSelfWithEnable(BlocksRegistry.IRON_PLINTH_BLOCK);
        this.dropSelfWithEnable(BlocksRegistry.IRON_PYLON_BLOCK);
        this.copyTagWithEnable(BlocksRegistry.IRON_CELL_BLOCK, (LootItemFunction.Builder)CopyNbtFunction.copyData((NbtProvider)ContextNbtProvider.BLOCK_ENTITY).copy("InputTank", "BlockEntityTag.InputTank", CopyNbtFunction.MergeStrategy.REPLACE));
        this.dropSelfWithEnable(BlocksRegistry.GOLD_PLINTH_BLOCK);
        this.dropSelfWithEnable(BlocksRegistry.GOLD_PYLON_BLOCK);
        this.copyTagWithEnable(BlocksRegistry.GOLD_CELL_BLOCK, (LootItemFunction.Builder)CopyNbtFunction.copyData((NbtProvider)ContextNbtProvider.BLOCK_ENTITY).copy("InputTank", "BlockEntityTag.InputTank", CopyNbtFunction.MergeStrategy.REPLACE));
        this.dropSelfWithEnable(BlocksRegistry.DIAMOND_PLINTH_BLOCK);
        this.dropSelfWithEnable(BlocksRegistry.DIAMOND_PYLON_BLOCK);
        this.copyTagWithEnable(BlocksRegistry.DIAMOND_CELL_BLOCK, (LootItemFunction.Builder)CopyNbtFunction.copyData((NbtProvider)ContextNbtProvider.BLOCK_ENTITY).copy("InputTank", "BlockEntityTag.InputTank", CopyNbtFunction.MergeStrategy.REPLACE));
        this.dropSelfWithEnable(BlocksRegistry.NETHERITE_PLINTH_BLOCK);
        this.dropSelfWithEnable(BlocksRegistry.NETHERITE_PYLON_BLOCK);
        this.copyTagWithEnable(BlocksRegistry.NETHERITE_CELL_BLOCK, (LootItemFunction.Builder)CopyNbtFunction.copyData((NbtProvider)ContextNbtProvider.BLOCK_ENTITY).copy("InputTank", "BlockEntityTag.InputTank", CopyNbtFunction.MergeStrategy.REPLACE));
        this.dropSelfWithEnable(BlocksRegistry.HEART_BLOCK);
        this.dropSelfWithEnable(BlocksRegistry.FACTORY_UPGRADE_BLOCK);
        this.dropSelfWithEnable(BlocksRegistry.FACTORY_CONNECT_BLOCK);
        this.dropSelfWithEnable(BlocksRegistry.FACTORY_CTR_BASE_PRI_BLOCK);
        this.dropSelfWithEnable(BlocksRegistry.FACTORY_CTR_BASE_SEC_BLOCK);
        this.dropSelfWithEnable(BlocksRegistry.IMPORT_BLOCK);
        this.dropSelfWithEnable(BlocksRegistry.EXPORT_BLOCK);
        this.dropSelf(BlocksRegistry.LAYOUT_BLOCK);
        this.dropSelf(BlocksRegistry.CREATIVE_POWER_BLOCK);
        this.copyTag(BlocksRegistry.CREATIVE_TANK_BLOCK, (LootItemFunction.Builder)CopyNbtFunction.copyData((NbtProvider)ContextNbtProvider.BLOCK_ENTITY).copy("InputTank", "BlockEntityTag.InputTank", CopyNbtFunction.MergeStrategy.REPLACE));
        this.copyTag(BlocksRegistry.FLUID_INFUSER_BLOCK, (LootItemFunction.Builder)CopyNbtFunction.copyData((NbtProvider)ContextNbtProvider.BLOCK_ENTITY).copy("Energy", "BlockEntityTag.Energy", CopyNbtFunction.MergeStrategy.REPLACE).copy("InputTank", "BlockEntityTag.InputTank", CopyNbtFunction.MergeStrategy.REPLACE).copy("OutputTank", "BlockEntityTag.OutputTank", CopyNbtFunction.MergeStrategy.REPLACE).copy("RedstoneMode", "BlockEntityTag.RedstoneMode", CopyNbtFunction.MergeStrategy.REPLACE).copy("MachineProperties", "BlockEntityTag.MachineProperties", CopyNbtFunction.MergeStrategy.REPLACE));
        this.copyTag(BlocksRegistry.ITEM_INFUSER_BLOCK, (LootItemFunction.Builder)CopyNbtFunction.copyData((NbtProvider)ContextNbtProvider.BLOCK_ENTITY).copy("Energy", "BlockEntityTag.Energy", CopyNbtFunction.MergeStrategy.REPLACE).copy("InputTank", "BlockEntityTag.InputTank", CopyNbtFunction.MergeStrategy.REPLACE).copy("RedstoneMode", "BlockEntityTag.RedstoneMode", CopyNbtFunction.MergeStrategy.REPLACE).copy("MachineProperties", "BlockEntityTag.MachineProperties", CopyNbtFunction.MergeStrategy.REPLACE));
        this.copyTag(BlocksRegistry.ENCHANTED_LIQUIFIER_BLOCK, (LootItemFunction.Builder)CopyNbtFunction.copyData((NbtProvider)ContextNbtProvider.BLOCK_ENTITY).copy("Energy", "BlockEntityTag.Energy", CopyNbtFunction.MergeStrategy.REPLACE).copy("OutputTank", "BlockEntityTag.OutputTank", CopyNbtFunction.MergeStrategy.REPLACE).copy("RedstoneMode", "BlockEntityTag.RedstoneMode", CopyNbtFunction.MergeStrategy.REPLACE).copy("MachineProperties", "BlockEntityTag.MachineProperties", CopyNbtFunction.MergeStrategy.REPLACE));
        this.copyTag(BlocksRegistry.DYE_LIQUIFIER_BLOCK, (LootItemFunction.Builder)CopyNbtFunction.copyData((NbtProvider)ContextNbtProvider.BLOCK_ENTITY).copy("Energy", "BlockEntityTag.Energy", CopyNbtFunction.MergeStrategy.REPLACE).copy("OutputTank", "BlockEntityTag.OutputTank", CopyNbtFunction.MergeStrategy.REPLACE).copy("RedstoneMode", "BlockEntityTag.RedstoneMode", CopyNbtFunction.MergeStrategy.REPLACE).copy("MachineProperties", "BlockEntityTag.MachineProperties", CopyNbtFunction.MergeStrategy.REPLACE).copy("InternalTanks", "BlockEntityTag.InternalTanks", CopyNbtFunction.MergeStrategy.REPLACE));
    }

    public ResourceLocation getBlockResource(Block block) {
        return Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)block));
    }

    public void dropSelf(DeferredHolder<Block, ? extends Block> block) {
        this.add((Block)block.get(), LootTables.noDrop().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((Block)block.get()))).unwrap()));
    }

    public void dropSelfWithEnable(DeferredHolder<Block, ? extends Block> block) {
        LootItemBlockStatePropertyCondition.Builder builder = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)block.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BlockStateProperties.ENABLED, true));
        this.add((Block)block.get(), LootTables.noDrop().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)((Block)block.get())).when((LootItemCondition.Builder)builder))));
    }

    public void copyTag(DeferredHolder<Block, ? extends Block> block, LootItemFunction.Builder builder) {
        this.add((Block)block.get(), LootTables.noDrop().withPool(LootPool.lootPool().name(this.getBlockResource((Block)block.get()).toString()).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((Block)block.get()).asItem()).apply(builder))));
    }

    public void copyTagWithEnable(DeferredHolder<Block, ? extends Block> block, LootItemFunction.Builder builder) {
        LootItemBlockStatePropertyCondition.Builder stateBuilder = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)block.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BlockStateProperties.ENABLED, true));
        this.add((Block)block.get(), LootTables.noDrop().withPool(LootPool.lootPool().name(this.getBlockResource((Block)block.get()).toString()).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when((LootItemCondition.Builder)stateBuilder).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((Block)block.get()).asItem()).apply(builder))));
    }
}

