/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.events;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityTravelToDimensionEvent;
import wootrevived.woot.drops.simulator.DropSimulatorDimension;

@Mod.EventBusSubscriber(modid="woot_revived")
public class DropSimulatorDimensionGuard {
    @SubscribeEvent
    public static void onDimensionChange(EntityTravelToDimensionEvent event) {
        ResourceKey dimension = event.getDimension();
        if (DropSimulatorDimension.DROP_SIMULATOR_LEVEL == dimension) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (DropSimulatorDimension.DROP_SIMULATOR_LEVEL == player.level().dimension()) {
            ServerLevel overworld = player.getServer().overworld();
            BlockPos respawnPos = overworld.getSharedSpawnPos();
            player.teleportTo(overworld, (double)respawnPos.getX(), (double)respawnPos.getY(), (double)respawnPos.getZ(), player.getYRot(), player.getXRot());
        }
    }
}

