/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.guide;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;

public class GuideBookPersistentState
extends SavedData {
    private static final SavedData.Factory<GuideBookPersistentState> FACTORY = new SavedData.Factory(GuideBookPersistentState::new, GuideBookPersistentState::fromTag);
    private static final String NAME = "woot_revived_guidebook";
    private final Set<String> receivedPlayers;

    private GuideBookPersistentState(Set<String> receivedPlayers) {
        this.receivedPlayers = receivedPlayers;
    }

    private GuideBookPersistentState() {
        this(new HashSet<String>());
    }

    public boolean hasPlayerReceivedGuideBook(Player player) {
        return this.receivedPlayers.contains(player.getStringUUID());
    }

    public void addPlayerReceivedGuideBook(Player player) {
        this.receivedPlayers.add(player.getStringUUID());
        this.setDirty();
    }

    public static GuideBookPersistentState fromTag(CompoundTag tag) {
        HashSet<String> receivedPlayers = new HashSet<String>();
        ListTag list = tag.getList("ReceivedPlayers", 8);
        for (int i = 0; i < list.size(); ++i) {
            receivedPlayers.add(list.getString(i));
        }
        return new GuideBookPersistentState(receivedPlayers);
    }

    public CompoundTag save(CompoundTag tag) {
        ListTag list = new ListTag();
        for (String receivedPlayer : this.receivedPlayers) {
            list.add((Object)StringTag.valueOf((String)receivedPlayer));
        }
        tag.put("ReceivedPlayers", (Tag)list);
        return tag;
    }

    public static GuideBookPersistentState get(MinecraftServer server) {
        ServerLevel level = server.getLevel(ServerLevel.OVERWORLD);
        return (GuideBookPersistentState)level.getDataStorage().computeIfAbsent(FACTORY, NAME);
    }
}

