/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.guide.recipes;

import guideme.document.LytRect;
import guideme.document.block.LytBlock;
import guideme.document.block.LytBox;
import guideme.document.block.LytSlot;
import guideme.layout.LayoutContext;
import guideme.render.RenderContext;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidStack;
import wootrevived.woot.client.render.dye_liquifier.DyeLiquifierContainerScreen;
import wootrevived.woot.config.DyeLiquifierConfig;
import wootrevived.woot.recipes.dye_liquifier.DyeLiquifierRecipe;
import wootrevived.woot.registries.FluidsRegistry;
import wootrevived.woot.util.render.guide.LytColorBar;
import wootrevived.woot.util.render.guide.LytEnergy;
import wootrevived.woot.util.render.guide.LytFluid;

public class LytDyeLiquifierRecipe
extends LytBox {
    private static final int GUI_WIDTH = 150;
    private static final int GUI_HEIGHT = 66;
    private static final int ENERGY_X = 5;
    private static final int ENERGY_Y = 5;
    private static final int INPUT_SLOT_X = 26;
    private static final int INPUT_SLOT_Y = 24;
    private static final int COLOR_BAR_X = 68;
    private static final int RED_COLOR_BAR_Y = 10;
    private static final int YELLOW_COLOR_BAR_Y = 22;
    private static final int BLUE_COLOR_BAR_Y = 34;
    private static final int WHITE_COLOR_BAR_Y = 46;
    private static final int OUTPUT_FLUID_X = 127;
    private static final int OUTPUT_FLUID_Y = 5;
    private static final int PROGRESS_X = 47;
    private static final int PROGRESS_Y = 12;
    private final LytEnergy energy;
    private final LytSlot inputSlot;
    private final LytColorBar redColorBar;
    private final LytColorBar yellowColorBar;
    private final LytColorBar blueColorBar;
    private final LytColorBar whiteColorBar;
    private final LytFluid outputFluid;

    public LytDyeLiquifierRecipe(RecipeHolder<DyeLiquifierRecipe> recipeHolder) {
        DyeLiquifierRecipe recipe = (DyeLiquifierRecipe)recipeHolder.value();
        this.energy = new LytEnergy(recipe.getEnergy(), (Integer)DyeLiquifierConfig.ENERGY_CAPACITY.get());
        this.append(this.energy);
        this.inputSlot = new LytSlot(Ingredient.of((TagKey)Tags.Items.DYES));
        this.append((LytBlock)this.inputSlot);
        this.redColorBar = new LytColorBar((Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get(), Math.round((float)((Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get()).intValue() * DyeLiquifierRecipe.maxMultiplier), DyeColor.RED.getTextureDiffuseColors(), Component.translatable((String)"info.woot_revived.dye.red"));
        this.append(this.redColorBar);
        this.yellowColorBar = new LytColorBar((Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get(), Math.round((float)((Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get()).intValue() * DyeLiquifierRecipe.maxMultiplier), DyeColor.YELLOW.getTextureDiffuseColors(), Component.translatable((String)"info.woot_revived.dye.yellow"));
        this.append(this.yellowColorBar);
        this.blueColorBar = new LytColorBar((Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get(), Math.round((float)((Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get()).intValue() * DyeLiquifierRecipe.maxMultiplier), DyeColor.BLUE.getTextureDiffuseColors(), Component.translatable((String)"info.woot_revived.dye.blue"));
        this.append(this.blueColorBar);
        this.whiteColorBar = new LytColorBar((Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get(), Math.round((float)((Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get()).intValue() * DyeLiquifierRecipe.maxMultiplier), DyeColor.WHITE.getTextureDiffuseColors(), Component.translatable((String)"info.woot_revived.dye.white"));
        this.append(this.whiteColorBar);
        this.outputFluid = new LytFluid(new FluidStack((Fluid)FluidsRegistry.SOURCE_PURE_DYE_FLUID.get(), ((Integer)DyeLiquifierConfig.PURE_DYE_PRODUCE_AMOUNT.get()).intValue()), (Integer)DyeLiquifierConfig.OUTPUT_TANK_CAPACITY.get());
        this.append(this.outputFluid);
    }

    protected LytRect computeBoxLayout(LayoutContext context, int x, int y, int availableWidth) {
        this.energy.layout(context, x + 5, y + 5, availableWidth);
        this.inputSlot.layout(context, x + 26, y + 24, availableWidth);
        this.redColorBar.layout(context, x + 68, y + 10, availableWidth);
        this.yellowColorBar.layout(context, x + 68, y + 22, availableWidth);
        this.blueColorBar.layout(context, x + 68, y + 34, availableWidth);
        this.whiteColorBar.layout(context, x + 68, y + 46, availableWidth);
        this.outputFluid.layout(context, x + 127, y + 5, availableWidth);
        return new LytRect(x, y, 150, 66);
    }

    public void render(RenderContext context) {
        context.renderPanel(this.bounds);
        DyeLiquifierContainerScreen.renderProgressBg(context.guiGraphics(), this.bounds.x() + 47, this.bounds.y() + 12);
        super.render(context);
    }
}

