/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.guide.recipes;

import guideme.document.LytRect;
import guideme.document.block.LytBlock;
import guideme.document.block.LytBox;
import guideme.document.block.LytSlot;
import guideme.layout.LayoutContext;
import guideme.render.RenderContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import wootrevived.woot.client.render.fluid_infuser.FluidInfuserContainerScreen;
import wootrevived.woot.config.FluidInfuserConfig;
import wootrevived.woot.recipes.fluid_infuser.FluidInfuserRecipe;
import wootrevived.woot.util.render.guide.LytEnergy;
import wootrevived.woot.util.render.guide.LytFluid;

public class LytFluidInfuserRecipe
extends LytBox {
    private static final int GUI_WIDTH = 139;
    private static final int GUI_HEIGHT = 66;
    private static final int ENERGY_X = 5;
    private static final int ENERGY_Y = 5;
    private static final int INPUT_SLOT_X = 71;
    private static final int INPUT_SLOT_Y = 10;
    private static final int INPUT_FLUID_X = 26;
    private static final int INPUT_FLUID_Y = 5;
    private static final int OUTPUT_FLUID_X = 116;
    private static final int OUTPUT_FLUID_Y = 5;
    private static final int PROGRESS_X = 48;
    private static final int PROGRESS_Y = 29;
    private final LytEnergy energy;
    private final LytFluid inputFluid;
    private final LytFluid outputFluid;
    private final LytSlot inputSlot;

    public LytFluidInfuserRecipe(RecipeHolder<FluidInfuserRecipe> recipeHolder) {
        FluidInfuserRecipe recipe = (FluidInfuserRecipe)recipeHolder.value();
        this.energy = new LytEnergy(recipe.getEnergy(), (Integer)FluidInfuserConfig.ENERGY_CAPACITY.get());
        this.append(this.energy);
        this.inputFluid = new LytFluid(recipe.getInputFluid(), (Integer)FluidInfuserConfig.INPUT_TANK_CAPACITY.get());
        this.append(this.inputFluid);
        this.outputFluid = new LytFluid(recipe.getOutputFluid(), (Integer)FluidInfuserConfig.OUTPUT_TANK_CAPACITY.get());
        this.append(this.outputFluid);
        this.inputSlot = new LytSlot(recipe.getIngredient());
        this.append((LytBlock)this.inputSlot);
    }

    protected LytRect computeBoxLayout(LayoutContext context, int x, int y, int availableWidth) {
        this.energy.layout(context, x + 5, y + 5, availableWidth);
        this.inputSlot.layout(context, x + 71, y + 10, availableWidth);
        this.inputFluid.layout(context, x + 26, y + 5, availableWidth);
        this.outputFluid.layout(context, x + 116, y + 5, availableWidth);
        return new LytRect(x, y, 139, 66);
    }

    public void render(RenderContext context) {
        context.renderPanel(this.bounds);
        FluidInfuserContainerScreen.renderProgressBg(context.guiGraphics(), this.bounds.x() + 48, this.bounds.y() + 29);
        super.render(context);
    }
}

