/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.items.mob_shard;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.api.WootFactoryMob;
import wootrevived.woot.config.MobShardConfig;
import wootrevived.woot.items.mob_shard.MobShardProjectile;
import wootrevived.woot.registries.ItemsRegistry;
import wootrevived.woot.registries.WootFactoryMobsRegistry;
import wootrevived.woot.util.helper.ModNameHelper;
import wootrevived.woot.util.helper.SerializeEntityNBTHelper;
import wootrevived.woot.util.render.WootStyles;

public class MobShardItem
extends Item {
    public MobShardItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public boolean hurtEnemy(@NotNull ItemStack stack, @NotNull LivingEntity target, LivingEntity tmpAttacker) {
        if (tmpAttacker.getCommandSenderWorld().isClientSide() || !(tmpAttacker instanceof Player)) {
            return false;
        }
        Player attacker = (Player)tmpAttacker;
        if (!WootFactoryMobsRegistry.hasFactoryMob(target.getType())) {
            return false;
        }
        WootFactoryMob<?> mob = WootFactoryMobsRegistry.getFactoryMob(target.getType());
        if (mob.isBlacklisted()) {
            return false;
        }
        if (MobShardItem.isProgrammed(stack)) {
            return false;
        }
        return this.setProgrammedMob(stack, mob.saveTag(SerializeEntityNBTHelper.serialize((Entity)target), (HolderLookup.Provider)target.level().registryAccess()));
    }

    public static boolean isProgrammed(ItemStack itemStack) {
        return itemStack.getOrCreateTag().contains("Mob");
    }

    public static CompoundTag getProgrammedMob(ItemStack itemStack) {
        CompoundTag tag = itemStack.getOrCreateTag();
        if (tag.contains("Mob")) {
            return tag.getCompound("Mob");
        }
        return null;
    }

    private boolean setProgrammedMob(ItemStack itemStack, CompoundTag mobTag) {
        if (!WootFactoryMobsRegistry.hasFactoryMob(mobTag)) {
            return false;
        }
        CompoundTag stackTag = itemStack.getOrCreateTag();
        stackTag.put("Mob", (Tag)mobTag);
        stackTag.putInt("Kills", 0);
        return true;
    }

    private static boolean isMatchingMob(ItemStack itemStack, CompoundTag mobTag, Level level) {
        if (itemStack.getItem() != ItemsRegistry.MOB_SHARD_ITEM.get()) {
            return false;
        }
        if (!MobShardItem.isProgrammed(itemStack)) {
            return false;
        }
        CompoundTag programmedMob = MobShardItem.getProgrammedMob(itemStack);
        if (programmedMob == null) {
            return false;
        }
        WootFactoryMob<?> mob = WootFactoryMobsRegistry.getFactoryMob(programmedMob);
        return mob.isSame(programmedMob, mobTag, (HolderLookup.Provider)level.registryAccess());
    }

    public static void handleKill(Player player, CompoundTag mobTag) {
        ItemStack foundStack = ItemStack.EMPTY;
        ItemStack inHandItemStack = player.getMainHandItem();
        if (!inHandItemStack.isEmpty() && MobShardItem.isMatchingMob(inHandItemStack, mobTag, player.level()) && !MobShardItem.isFullyProgrammed(inHandItemStack)) {
            foundStack = inHandItemStack;
        } else {
            ArrayList inventoryItems = new ArrayList();
            inventoryItems.addAll(player.getInventory().offhand);
            inventoryItems.addAll(player.getInventory().items);
            for (ItemStack itemStack : inventoryItems) {
                if (inHandItemStack.equals(itemStack) || itemStack.isEmpty() || !MobShardItem.isMatchingMob(itemStack, mobTag, player.level()) || MobShardItem.isFullyProgrammed(itemStack)) continue;
                foundStack = itemStack;
                break;
            }
        }
        if (!foundStack.isEmpty()) {
            MobShardItem.incrementKills(foundStack, 1);
        }
    }

    public static void incrementKills(ItemStack itemStack, int amount) {
        if (itemStack.getItem() != ItemsRegistry.MOB_SHARD_ITEM.get()) {
            return;
        }
        CompoundTag mobTag = MobShardItem.getProgrammedMob(itemStack);
        if (mobTag == null) {
            return;
        }
        int killCount = itemStack.getOrCreateTag().getInt("Kills");
        if (!MobShardItem.isFull(itemStack)) {
            itemStack.getOrCreateTag().putInt("Kills", killCount += amount);
        }
    }

    private static boolean isFull(ItemStack itemStack) {
        int killCount = itemStack.getOrCreateTag().getInt("Kills");
        CompoundTag mobTag = MobShardItem.getProgrammedMob(itemStack);
        if (mobTag == null) {
            return false;
        }
        return killCount >= (Integer)MobShardConfig.NUM_OF_KILLS.get();
    }

    public static void setJEIShard(ItemStack itemStack) {
        CompoundTag tag = new CompoundTag();
        tag.putInt("nbt_jei_shard", 1);
        itemStack.setTag(tag);
    }

    public static boolean isJEIShard(ItemStack itemStack) {
        return itemStack.getOrCreateTag().contains("nbt_jei_shard");
    }

    public static boolean isFullyProgrammed(ItemStack itemStack) {
        return MobShardItem.isProgrammed(itemStack) && MobShardItem.isFull(itemStack);
    }

    public boolean isFoil(@NotNull ItemStack itemStack) {
        if (MobShardItem.isFullyProgrammed(itemStack)) {
            return true;
        }
        return MobShardItem.isJEIShard(itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        WootFactoryMob<?> mob;
        super.appendHoverText(stack, level, tooltip, flag);
        if (MobShardItem.isJEIShard(stack)) {
            tooltip.add((Component)Component.translatable((String)"info.woot_revived.mobshard.programmed").setStyle(WootStyles.SHARD_PROGRAM_STYLE));
            return;
        }
        CompoundTag mobTag = MobShardItem.getProgrammedMob(stack);
        if (mobTag == null) {
            tooltip.add((Component)Component.translatable((String)"info.woot_revived.mobshard.unprogrammed").setStyle(WootStyles.SHARD_PROGRAM_STYLE));
            tooltip.add((Component)Component.translatable((String)"info.woot_revived.mobshard.unprogrammed.desc").setStyle(WootStyles.DESCRIPTION_STYLE));
            return;
        }
        if (level == null) {
            level = Minecraft.getInstance().level;
        }
        if ((mob = WootFactoryMobsRegistry.getFactoryMob(mobTag)) != null) {
            tooltip.add((Component)mob.getDisplayName(mobTag, (HolderLookup.Provider)level.registryAccess()).setStyle(WootStyles.CAPTURED_STYLE));
            String modId = BuiltInRegistries.ENTITY_TYPE.getKey(mob.getEntityType()).getNamespace();
            tooltip.add((Component)ModNameHelper.getModName(modId).setStyle(WootStyles.MOD_NAME_STYLE));
        }
        int killCount = stack.getOrCreateTag().getInt("Kills");
        if (MobShardItem.isFull(stack)) {
            tooltip.add((Component)Component.translatable((String)"info.woot_revived.mobshard.programmed").setStyle(WootStyles.SHARD_PROGRAM_STYLE));
        } else {
            tooltip.add((Component)Component.translatable((String)"info.woot_revived.mobshard.remaining", (Object[])new Object[]{killCount, MobShardConfig.NUM_OF_KILLS.get()}).setStyle(WootStyles.SHARD_PROGRAM_STYLE));
            if (mob != null) {
                tooltip.add((Component)Component.translatable((String)"info.woot_revived.mobshard.remaining.desc", (Object[])new Object[]{mob.getTooltipKillName(mobTag, (HolderLookup.Provider)level.registryAccess()).setStyle(WootStyles.DESCRIPTION_STYLE)}).setStyle(WootStyles.DESCRIPTION_STYLE));
            } else {
                tooltip.add((Component)Component.translatable((String)"info.woot_revived.mobshard.remaining.desc_no_entity").setStyle(WootStyles.DESCRIPTION_STYLE));
            }
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand usedHand) {
        ItemStack itemStack = player.getItemInHand(usedHand);
        if (MobShardItem.isProgrammed(itemStack)) {
            return InteractionResultHolder.fail((Object)itemStack);
        }
        player.startUsingItem(usedHand);
        return InteractionResultHolder.consume((Object)itemStack);
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(@NotNull ItemStack stack) {
        return 72000;
    }

    public void releaseUsing(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity, int timeLeft) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int used = this.getUseDuration(stack) - timeLeft;
        float pull = Math.min((float)used / 20.0f, 1.0f);
        MobShardProjectile proj = new MobShardProjectile(player, level);
        proj.setItem(stack);
        proj.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, pull * 2.0f, 1.0f - pull * 0.5f);
        if (!level.isClientSide) {
            level.addFreshEntity((Entity)proj);
        }
        stack.shrink(1);
    }
}

