/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.items.mob_shard;

import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.PartEntity;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.items.mob_shard.MobShardItem;
import wootrevived.woot.items.mob_shard.MobShardItemEntity;
import wootrevived.woot.registries.ItemsRegistry;

public class MobShardProjectile
extends ThrowableItemProjectile {
    public static String MOB_SHARD_KILLED_BY_PROJECTILE = "MOB_SHARD_KILLED_BY_PROJECTILE";
    public static String MOB_SHARD_HAS_BEEN_KILLED = "MOB_SHARD_HAS_BEEN_KILLED";

    public MobShardProjectile(EntityType<MobShardProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public MobShardProjectile(Player player, Level level) {
        super((EntityType)ItemsRegistry.MOB_SHARD_PROJECTILE.get(), (LivingEntity)player, level);
    }

    @NotNull
    protected Item getDefaultItem() {
        return (Item)ItemsRegistry.MOB_SHARD_ITEM.get();
    }

    public void tick() {
        super.tick();
        Vec3 vec3 = this.getDeltaMovement();
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            double d0 = vec3.horizontalDistance();
            this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875));
            this.setXRot((float)(Mth.atan2((double)vec3.y, (double)d0) * 57.2957763671875));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
        if (this.isInLava()) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void onHitBlock(@NotNull BlockHitResult result) {
        if (!this.level().isClientSide) {
            this.remove(Entity.RemovalReason.DISCARDED);
            BlockPos pos = result.getBlockPos();
            this.dropItem(this.getItem(), pos);
        }
        super.onHitBlock(result);
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        super.onHitEntity(result);
        if (!this.level().isClientSide) {
            Entity target = result.getEntity();
            Entity shooter = this.getOwner();
            ItemStack itemStack = this.getItem();
            if (shooter instanceof Player) {
                Player player = (Player)shooter;
                Entity realTarget = target;
                while (realTarget instanceof PartEntity) {
                    PartEntity partEntity = (PartEntity)realTarget;
                    realTarget = partEntity.getParent();
                }
                DamageSources sources = new DamageSources(this.level().registryAccess());
                realTarget.addTag(MOB_SHARD_KILLED_BY_PROJECTILE);
                target.hurt(sources.playerAttack(player), 1.0f);
                if (realTarget instanceof Mob) {
                    Mob mob = (Mob)realTarget;
                    Item item = itemStack.getItem();
                    item.hurtEnemy(itemStack, (LivingEntity)mob, (LivingEntity)player);
                    if (realTarget.getTags().contains(MOB_SHARD_HAS_BEEN_KILLED)) {
                        realTarget.removeTag(MOB_SHARD_HAS_BEEN_KILLED);
                        MobShardItem.incrementKills(itemStack, 1);
                    }
                }
                realTarget.removeTag(MOB_SHARD_KILLED_BY_PROJECTILE);
            }
            this.remove(Entity.RemovalReason.DISCARDED);
            BlockPos pos = result.getEntity().getOnPos();
            this.dropItem(itemStack, pos);
        }
    }

    private void dropItem(ItemStack itemStack, BlockPos pos) {
        Level level = this.level();
        if (level.isClientSide) {
            return;
        }
        if (level.getBlockState(pos.above()).isAir()) {
            pos = pos.above();
        } else if (level.getBlockState(pos.below()).isAir()) {
            pos = pos.below();
        } else if (level.getBlockState(pos.east()).isAir()) {
            pos = pos.east();
        } else if (level.getBlockState(pos.west()).isAir()) {
            pos = pos.west();
        } else if (level.getBlockState(pos.north()).isAir()) {
            pos = pos.north();
        } else if (level.getBlockState(pos.south()).isAir()) {
            pos = pos.south();
        }
        double x = pos.getX();
        double y = pos.getY();
        double z = pos.getZ();
        double d0 = EntityType.ITEM.getWidth();
        double d1 = 1.0 - d0;
        double d2 = d0 / 2.0;
        double d3 = Math.floor(x) + level.random.nextDouble() * d1 + d2;
        double d4 = Math.floor(y) + level.random.nextDouble() * d1;
        double d5 = Math.floor(z) + level.random.nextDouble() * d1 + d2;
        while (!itemStack.isEmpty()) {
            MobShardItemEntity itementity = new MobShardItemEntity(level, d3, d4, d5, itemStack.split(level.random.nextInt(21) + 10));
            itementity.setDeltaMovement(level.random.triangle(0.0, 0.11485000171139836), level.random.triangle(0.2, 0.11485000171139836), level.random.triangle(0.0, 0.11485000171139836));
            level.addFreshEntity((Entity)itementity);
        }
    }
}

