/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.multiblock;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.api.enums.Tier;
import wootrevived.woot.multiblock.MultiBlockFactory;
import wootrevived.woot.util.common.WootTier;

public abstract class MultiBlockFactoryEntity
extends BlockEntity
implements BlockEntityTicker<BlockEntity> {
    protected Tier tier = Tier.INVALID;

    public MultiBlockFactoryEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void ticker(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof MultiBlockFactoryEntity) {
            MultiBlockFactoryEntity multiBlockFactoryEntity = (MultiBlockFactoryEntity)blockEntity;
            multiBlockFactoryEntity.tick(level, pos, state, blockEntity);
        }
    }

    public void updatePattern(Level level) {
        Direction facing = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        Tier newTier = MultiBlockFactory.updatePattern(level, this.getBlockPos(), facing);
        if (newTier != this.tier) {
            this.tier = newTier;
            this.setChanged();
        }
    }

    public Tier getFactoryTier() {
        return this.tier;
    }

    protected void saveAdditional(@NotNull CompoundTag tag) {
        super.saveAdditional(tag);
        tag.putInt("Tier", this.tier.ordinal());
    }

    public void load(@NotNull CompoundTag tag) {
        super.load(tag);
        this.tier = WootTier.byIndex(tag.getInt("Tier"));
    }

    @NotNull
    public CompoundTag getUpdateTag() {
        CompoundTag tag = super.getUpdateTag();
        this.saveAdditional(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.load(tag);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void setChanged() {
        super.setChanged();
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }
}

