/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.multiblock.patterns;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import wootrevived.woot.blocks.fake_spawner.FakeSpawnerBlockEntity;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.util.block.FactoryBlockBaseEntity;

public class Pattern {
    public Map<Direction, List<PatternBlock>> patterns = Maps.newEnumMap(Direction.class);

    public Pattern(PatternBlock[] pattern, Direction facing) {
        this.patterns.put(facing, Arrays.stream(pattern).toList());
        for (int i = 0; i < 3; ++i) {
            List<PatternBlock> blocks = this.patterns.get(facing);
            ArrayList<PatternBlock> rotatedPattern = new ArrayList<PatternBlock>();
            for (PatternBlock patternBlock : blocks) {
                rotatedPattern.add(patternBlock.rotate(Rotation.CLOCKWISE_90));
            }
            facing = facing.getClockWise();
            this.patterns.put(facing, rotatedPattern);
        }
    }

    public boolean isPatternValid(Level level, BlockPos factoryPos, Direction facing) {
        List<PatternBlock> pattern = this.patterns.get(facing);
        for (PatternBlock patternBlock : pattern) {
            BlockPos blockPos;
            BlockState blockState;
            Block block;
            if (patternBlock.checkBlocks(level, block = (blockState = level.getBlockState(blockPos = patternBlock.getLevelBlockPos(factoryPos))).getBlock(), blockState, factoryPos, blockPos)) continue;
            return false;
        }
        return true;
    }

    public void setAttached(boolean isAttached, Level level, BlockPos factoryPos, Direction facing) {
        List<PatternBlock> pattern = this.patterns.get(facing);
        for (PatternBlock patternBlock : pattern) {
            BlockPos blockPos;
            BlockState blockState;
            if (!patternBlock.blockCanAttach(level, (blockState = level.getBlockState(blockPos = patternBlock.getLevelBlockPos(factoryPos))).getBlock(), blockState, factoryPos, blockPos)) continue;
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (blockEntity instanceof FactoryBlockBaseEntity) {
                FactoryBlockBaseEntity entity = (FactoryBlockBaseEntity)blockEntity;
                if (isAttached && entity.isHeartPosEmpty()) {
                    entity.setHeartPos(factoryPos);
                } else {
                    if (!isAttached && !entity.isSameHeartPos(factoryPos)) continue;
                    if (!isAttached) {
                        entity.setHeartPos(null);
                    }
                }
            }
            if (!blockState.hasProperty((Property)BlockStateProperties.ATTACHED) || (Boolean)blockState.getValue((Property)BlockStateProperties.ATTACHED) == isAttached) continue;
            level.setBlock(blockPos, (BlockState)blockState.setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(isAttached)), 3);
        }
    }

    public static class PatternBlock {
        public Block[] blocks;
        public BlockPos pos;
        public boolean hasAir;

        public PatternBlock(BlockPos pos, Block ... blocks) {
            this.blocks = blocks;
            this.pos = pos;
            for (Block block : blocks) {
                if (block != Blocks.AIR) continue;
                this.hasAir = true;
                break;
            }
        }

        public PatternBlock(int x, int y, int z, Block ... blocks) {
            this(new BlockPos(x, y, z), blocks);
        }

        public BlockPos getLevelBlockPos(BlockPos factoryBlockPos) {
            return factoryBlockPos.offset((Vec3i)this.pos);
        }

        public PatternBlock rotate(Rotation rotation) {
            return new PatternBlock(this.pos.rotate(rotation), this.blocks);
        }

        public boolean checkBlocks(Level level, Block block, BlockState blockState, BlockPos factoryPos, BlockPos levelPos) {
            if (this.hasAir) {
                return true;
            }
            for (Block b : this.blocks) {
                FactoryBlockBaseEntity entity;
                BlockEntity blockEntity;
                FakeSpawnerBlockEntity fakeSpawnerBlockEntity;
                if (b != block || blockState.hasProperty((Property)BlockStateProperties.ENABLED) && !((Boolean)blockState.getValue((Property)BlockStateProperties.ENABLED)).booleanValue() || block == BlocksRegistry.FAKE_SPAWNER_BLOCK.get() && (fakeSpawnerBlockEntity = (FakeSpawnerBlockEntity)level.getBlockEntity(levelPos)) != null && fakeSpawnerBlockEntity.getMobTag() == null || (blockEntity = level.getBlockEntity(levelPos)) instanceof FactoryBlockBaseEntity && !(entity = (FactoryBlockBaseEntity)blockEntity).isHeartPosEmpty() && !entity.isSameHeartPos(factoryPos)) continue;
                return true;
            }
            return false;
        }

        public boolean blockCanAttach(Level level, Block block, BlockState blockState, BlockPos factoryPos, BlockPos levelPos) {
            for (Block b : this.blocks) {
                FactoryBlockBaseEntity entity;
                BlockEntity blockEntity;
                FakeSpawnerBlockEntity fakeSpawnerBlockEntity;
                if (this.hasAir && b == Blocks.AIR || b != block || blockState.hasProperty((Property)BlockStateProperties.ENABLED) && !((Boolean)blockState.getValue((Property)BlockStateProperties.ENABLED)).booleanValue() || block == BlocksRegistry.FAKE_SPAWNER_BLOCK.get() && (fakeSpawnerBlockEntity = (FakeSpawnerBlockEntity)level.getBlockEntity(levelPos)) != null && fakeSpawnerBlockEntity.getMobTag() == null || (blockEntity = level.getBlockEntity(levelPos)) instanceof FactoryBlockBaseEntity && !(entity = (FactoryBlockBaseEntity)blockEntity).isHeartPosEmpty() && !entity.isSameHeartPos(factoryPos)) continue;
                return true;
            }
            return false;
        }
    }
}

