/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.network;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import wootrevived.woot.Woot;
import wootrevived.woot.util.common.MachineSide;
import wootrevived.woot.util.common.MachineSideProperty;
import wootrevived.woot.util.common.RedstoneMode;
import wootrevived.woot.util.entity.WootMachineBlockEntity;

public record WootMachineUpdate(BlockPos blockPos, RedstoneMode redstoneMode, List<Map<MachineSide, MachineSideProperty>> listMachineProperties) implements CustomPacketPayload
{
    public static final ResourceLocation ID = Woot.location("woot_machine_update");

    public static WootMachineUpdate read(FriendlyByteBuf buf) {
        int size = buf.readVarInt();
        ArrayList<Map<MachineSide, MachineSideProperty>> listMachineProperties = new ArrayList<Map<MachineSide, MachineSideProperty>>(size);
        for (int i = 0; i < size; ++i) {
            EnumMap machineSideProperties = Maps.newEnumMap(MachineSide.class);
            for (int j = 0; j < MachineSide.values().length; ++j) {
                machineSideProperties.put((MachineSide)buf.readEnum(MachineSide.class), (MachineSideProperty)buf.readEnum(MachineSideProperty.class));
            }
            listMachineProperties.add(machineSideProperties);
        }
        return new WootMachineUpdate(buf.readBlockPos(), (RedstoneMode)buf.readEnum(RedstoneMode.class), listMachineProperties);
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            WootMachineBlockEntity wootMachineBlockEntity;
            Player sender = ctx.player().orElse(null);
            if (!(sender instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)sender;
            if (!player.level().isLoaded(this.blockPos)) {
                return;
            }
            BlockEntity blockEntity = player.level().getBlockEntity(this.blockPos);
            if (blockEntity instanceof WootMachineBlockEntity && (wootMachineBlockEntity = (WootMachineBlockEntity)blockEntity).canPlayerAccess(player)) {
                wootMachineBlockEntity.handleNewState(this);
            }
        });
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeVarInt(this.listMachineProperties.size());
        for (Map<MachineSide, MachineSideProperty> machineProperties : this.listMachineProperties) {
            for (Map.Entry<MachineSide, MachineSideProperty> entry : machineProperties.entrySet()) {
                buf.writeEnum((Enum)entry.getKey());
                buf.writeEnum((Enum)entry.getValue());
            }
        }
        buf.writeBlockPos(this.blockPos);
        buf.writeEnum((Enum)this.redstoneMode);
    }

    public ResourceLocation id() {
        return ID;
    }
}

