/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.recipes.dye_liquifier;

import com.mojang.serialization.Codec;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.recipes.dye_liquifier.DyeLiquifierRecipe;
import wootrevived.woot.util.helper.RecipeHelper;

public class DyeLiquifierRecipeSerializer
implements RecipeSerializer<DyeLiquifierRecipe> {
    protected final IFactory<DyeLiquifierRecipe> factory;

    public DyeLiquifierRecipeSerializer(IFactory<DyeLiquifierRecipe> factory) {
        this.factory = factory;
    }

    @NotNull
    public Codec<DyeLiquifierRecipe> codec() {
        return DyeLiquifierRecipe.CODEC.codec();
    }

    @NotNull
    public DyeLiquifierRecipe fromNetwork(FriendlyByteBuf buffer) {
        int energy = buffer.readVarInt();
        float red = buffer.readFloat();
        float yellow = buffer.readFloat();
        float blue = buffer.readFloat();
        float white = buffer.readFloat();
        Ingredient ingredient = RecipeHelper.IngredientInput.fromNetwork(buffer);
        return this.factory.create(energy, red, yellow, blue, white, ingredient);
    }

    public void toNetwork(FriendlyByteBuf buffer, DyeLiquifierRecipe recipe) {
        buffer.writeVarInt(recipe.getEnergy());
        buffer.writeFloat((float)recipe.getRed());
        buffer.writeFloat((float)recipe.getYellow());
        buffer.writeFloat((float)recipe.getBlue());
        buffer.writeFloat((float)recipe.getWhite());
        RecipeHelper.IngredientInput.toNetwork(buffer, recipe.getIngredient());
    }

    public static interface IFactory<T> {
        public T create(int var1, float var2, float var3, float var4, float var5, @NotNull Ingredient var6);
    }
}

