/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.recipes.fluid_infuser;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.registries.RecipesRegistry;
import wootrevived.woot.util.recipes.WootContainer;

public class FluidInfuserRecipe
implements Recipe<WootContainer> {
    public static final MapCodec<FluidInfuserRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("energy").forGetter(FluidInfuserRecipe::getEnergy), (App)FluidStack.CODEC.fieldOf("input_fluid").forGetter(FluidInfuserRecipe::getInputFluid), (App)Ingredient.CODEC.fieldOf("ingredient").forGetter(FluidInfuserRecipe::getIngredient), (App)FluidStack.CODEC.fieldOf("output_fluid").forGetter(FluidInfuserRecipe::getOutputFluid)).apply((Applicative)inst, FluidInfuserRecipe::new));
    private final int energy;
    private final FluidStack inputFluid;
    private final Ingredient ingredient;
    private final FluidStack outputFluid;

    public FluidInfuserRecipe(int energy, @NotNull FluidStack inputFluid, @NotNull Ingredient ingredient, @NotNull FluidStack outputFluid) {
        this.energy = energy;
        this.inputFluid = inputFluid;
        this.ingredient = ingredient;
        this.outputFluid = outputFluid;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipesRegistry.FLUID_INFUSER_RECIPE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)RecipesRegistry.FLUID_INFUSER_RECIPE_TYPE.get();
    }

    public FluidStack getInputFluid() {
        return this.inputFluid.copy();
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public FluidStack getOutputFluid() {
        return this.outputFluid.copy();
    }

    public int getEnergy() {
        return this.energy;
    }

    public int ingredientCount(Item item) {
        for (ItemStack stack : this.ingredient.getItems()) {
            if (!stack.is(item)) continue;
            return stack.getCount();
        }
        return 0;
    }

    public boolean matches(@NotNull WootContainer container, @NotNull Level level) {
        if (!this.getInputFluid().isFluidEqual(container.getFluid(0))) {
            return false;
        }
        return this.getIngredient().test(container.getItem(1));
    }

    public static void loadRecipes(@NotNull RecipeManager manager) {
        Validator.clear();
        for (RecipeHolder recipeHolder : manager.getAllRecipesFor((RecipeType)RecipesRegistry.FLUID_INFUSER_RECIPE_TYPE.get())) {
            Validator.add(((FluidInfuserRecipe)recipeHolder.value()).ingredient, ((FluidInfuserRecipe)recipeHolder.value()).inputFluid);
        }
    }

    @NotNull
    public ItemStack assemble(@NotNull WootContainer container, @NotNull RegistryAccess registryAccess) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull RegistryAccess registryAccess) {
        return ItemStack.EMPTY;
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Validator {
        private static final List<Ingredient> validIngredients = new ArrayList<Ingredient>();
        private static final List<FluidStack> validFluids = new ArrayList<FluidStack>();

        public static boolean isCatalystValid(ItemStack item) {
            for (Ingredient ingredient : validIngredients) {
                if (!ingredient.test(item)) continue;
                return true;
            }
            return false;
        }

        public static boolean isFluidValid(FluidStack fluid) {
            for (FluidStack fluidStack : validFluids) {
                if (!fluidStack.isFluidEqual(fluid)) continue;
                return true;
            }
            return false;
        }

        protected static void add(Ingredient ingredient, FluidStack fluid) {
            validIngredients.add(ingredient);
            validFluids.add(fluid);
        }

        protected static void clear() {
            validIngredients.clear();
            validFluids.clear();
        }
    }
}

